/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service.routing;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.StringUtils;
import org.zowe.apiml.product.routing.RoutedService;

public abstract class RouteDefinitionProducer {
    protected final SimpleEvaluationContext evalCtxt = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    protected final Expression urlExpr;

    protected RouteDefinitionProducer(DiscoveryLocatorProperties properties) {
        SpelExpressionParser parser = new SpelExpressionParser();
        this.urlExpr = parser.parseExpression(properties.getUrlExpression());
    }

    protected String evalHostname(ServiceInstance serviceInstance) {
        return (String)this.urlExpr.getValue((EvaluationContext)this.evalCtxt, (Object)serviceInstance, String.class);
    }

    protected String getHostname(ServiceInstance serviceInstance) {
        String output = null;
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null) {
            output = (String)metadata.get("apiml.service.externalUrl");
        }
        if (output == null) {
            output = this.evalHostname(serviceInstance);
        }
        return output;
    }

    protected ServiceInstance getEvalServiceInstance(ServiceInstance serviceInstance) {
        String apimlId;
        String serviceId = serviceInstance.getServiceId();
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null && StringUtils.hasText((String)(apimlId = (String)metadata.get("apiml.service.apimlId")))) {
            serviceId = apimlId;
        }
        return new ServiceInstanceEval(serviceInstance, serviceId.toLowerCase());
    }

    protected RouteDefinition buildRouteDefinition(ServiceInstance serviceInstance, String routeId) {
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setId(serviceInstance.getInstanceId() + ":" + routeId);
        routeDefinition.setOrder(this.getOrder());
        routeDefinition.setUri(URI.create(this.getHostname(serviceInstance)));
        routeDefinition.setMetadata(new LinkedHashMap(serviceInstance.getMetadata()));
        return routeDefinition;
    }

    public abstract int getOrder();

    protected abstract void setCondition(RouteDefinition var1, ServiceInstance var2, RoutedService var3);

    protected abstract void setFilters(RouteDefinition var1, ServiceInstance var2, RoutedService var3);

    public RouteDefinition get(ServiceInstance serviceInstance, RoutedService routedService) {
        serviceInstance = this.getEvalServiceInstance(serviceInstance);
        RouteDefinition routeDefinition = this.buildRouteDefinition(serviceInstance, routedService.getSubServiceId());
        this.setCondition(routeDefinition, serviceInstance, routedService);
        this.setFilters(routeDefinition, serviceInstance, routedService);
        return routeDefinition;
    }

    static class ServiceInstanceEval
    implements ServiceInstance {
        private final ServiceInstance original;
        private final String evalServiceId;

        public String getServiceId() {
            return this.evalServiceId;
        }

        @Generated
        public ServiceInstanceEval(ServiceInstance original, String evalServiceId) {
            this.original = original;
            this.evalServiceId = evalServiceId;
        }

        @Generated
        public String getInstanceId() {
            return this.original.getInstanceId();
        }

        @Generated
        public String getHost() {
            return this.original.getHost();
        }

        @Generated
        public int getPort() {
            return this.original.getPort();
        }

        @Generated
        public boolean isSecure() {
            return this.original.isSecure();
        }

        @Generated
        public URI getUri() {
            return this.original.getUri();
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.original.getMetadata();
        }

        @Generated
        public String getScheme() {
            return this.original.getScheme();
        }

        private static interface Overridden {
            public String getServiceId();
        }
    }
}

