/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.scheduled;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.zowe.apiml.cloudgatewayservice.service.GatewayIndexService;
import org.zowe.apiml.cloudgatewayservice.service.InstanceInfoService;
import org.zowe.apiml.product.constants.CoreService;
import org.zowe.apiml.services.BasicInfoService;
import org.zowe.apiml.services.ServiceInfo;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@EnableScheduling
@Component
@ConditionalOnExpression(value="${apiml.cloudGateway.registry.enabled:false}")
public class GatewayScanJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayScanJob.class);
    private final BasicInfoService basicInfoService;
    private final EurekaRegistration serviceRegistration;
    private final GatewayIndexService gatewayIndexerService;
    private final InstanceInfoService instanceInfoService;
    @Value(value="${apiml.service.apimlId:#{null}}")
    private String currentApimlId;
    @Value(value="${apiml.cloudGateway.maxSimultaneousRequests:20}")
    private int maxSimultaneousRequests;

    @Scheduled(initialDelay=5000L, fixedDelayString="${apiml.cloudGateway.refresh-interval-ms:30000}")
    public void startScanExternalGatewayJob() {
        log.debug("Scan gateways job start");
        this.doScanExternalGateway().subscribe();
        this.addLocalServices();
    }

    private void addLocalServices() {
        String apimlIdKey = Optional.ofNullable(this.currentApimlId).orElse(this.serviceRegistration.getInstanceId());
        List localServices = this.basicInfoService.getServicesInfo();
        this.gatewayIndexerService.putApimlServices(apimlIdKey, localServices);
    }

    protected Flux<List<ServiceInfo>> doScanExternalGateway() {
        Mono registeredGateways = this.instanceInfoService.getServiceInstance(CoreService.GATEWAY.getServiceId()).map(gateways -> gateways.stream().filter(info -> !StringUtils.equals((String)info.getMetadata().getOrDefault("apiml.service.apimlId", "N/A"), (String)this.currentApimlId)).collect(Collectors.toList()));
        Flux serviceInstanceFlux = registeredGateways.flatMapMany(Flux::fromIterable);
        return serviceInstanceFlux.flatMap(this.gatewayIndexerService::indexGatewayServices, this.maxSimultaneousRequests);
    }

    @Generated
    public GatewayScanJob(BasicInfoService basicInfoService, EurekaRegistration serviceRegistration, GatewayIndexService gatewayIndexerService, InstanceInfoService instanceInfoService) {
        this.basicInfoService = basicInfoService;
        this.serviceRegistration = serviceRegistration;
        this.gatewayIndexerService = gatewayIndexerService;
        this.instanceInfoService = instanceInfoService;
    }
}

