/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.net.HttpCookie;
import java.security.cert.CertificateEncodingException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.cloudgatewayservice.filters.RobinRoundIterator;
import org.zowe.apiml.cloudgatewayservice.service.InstanceInfoService;
import org.zowe.apiml.cloudgatewayservice.x509.X509Util;
import org.zowe.apiml.message.core.MessageService;
import reactor.core.publisher.Mono;

public abstract class AbstractAuthSchemeFactory<T extends AbstractConfig, R, D>
extends AbstractGatewayFilterFactory<T> {
    private static final String HEADER_SERVICE_ID = "X-Service-Id";
    private static final Predicate<HttpCookie> CREDENTIALS_COOKIE_INPUT = cookie -> StringUtils.equalsIgnoreCase((CharSequence)cookie.getName(), (CharSequence)"personalAccessToken") || StringUtils.equalsIgnoreCase((CharSequence)cookie.getName(), (CharSequence)"apimlAuthenticationToken") || StringUtils.startsWithIgnoreCase((CharSequence)cookie.getName(), (CharSequence)"apimlAuthenticationToken.");
    private static final Predicate<HttpCookie> CREDENTIALS_COOKIE = cookie -> CREDENTIALS_COOKIE_INPUT.test((HttpCookie)cookie) || StringUtils.equalsIgnoreCase((CharSequence)cookie.getName(), (CharSequence)"jwtToken") || StringUtils.equalsIgnoreCase((CharSequence)cookie.getName(), (CharSequence)"LtpaToken2");
    private static final Predicate<String> CREDENTIALS_HEADER_INPUT = headerName -> StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"Authorization") || StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"PRIVATE-TOKEN");
    private static final Predicate<String> CREDENTIALS_HEADER = headerName -> CREDENTIALS_HEADER_INPUT.test((String)headerName) || StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"X-SAF-Token") || StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"X-Certificate-Public") || StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"X-Certificate-DistinguishedName") || StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"X-Certificate-CommonName") || StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"Client-Cert") || StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"Cookie");
    private static final RobinRoundIterator<ServiceInstance> robinRound = new RobinRoundIterator();
    protected final WebClient webClient;
    protected final InstanceInfoService instanceInfoService;
    protected final MessageService messageService;

    protected AbstractAuthSchemeFactory(Class<T> configClazz, WebClient webClient, InstanceInfoService instanceInfoService, MessageService messageService) {
        super(configClazz);
        this.webClient = webClient;
        this.instanceInfoService = instanceInfoService;
        this.messageService = messageService;
    }

    protected abstract Class<R> getResponseClass();

    protected abstract R getResponseFor401();

    private Mono<List<ServiceInstance>> getZaasInstances() {
        return this.instanceInfoService.getServiceInstance("gateway");
    }

    private Mono<R> requestWithHa(Iterator<ServiceInstance> serviceInstanceIterator, Function<ServiceInstance, WebClient.RequestHeadersSpec<?>> requestCreator) {
        return requestCreator.apply(serviceInstanceIterator.next()).retrieve().onStatus(HttpStatus::is5xxServerError, clientResponse -> Mono.empty()).bodyToMono(this.getResponseClass()).onErrorResume(exception -> exception instanceof WebClientResponseException.Unauthorized ? Mono.just(this.getResponseFor401()) : Mono.error((Throwable)exception)).switchIfEmpty((Mono)(serviceInstanceIterator.hasNext() ? this.requestWithHa(serviceInstanceIterator, requestCreator) : Mono.empty()));
    }

    protected Mono<Void> invoke(List<ServiceInstance> serviceInstances, Function<ServiceInstance, WebClient.RequestHeadersSpec<?>> requestCreator, Function<? super R, ? extends Mono<Void>> responseProcessor) {
        Iterator<ServiceInstance> i = robinRound.getIterator(serviceInstances);
        if (!i.hasNext()) {
            throw new IllegalArgumentException("No ZAAS is available");
        }
        return this.requestWithHa(i, requestCreator).flatMap(responseProcessor);
    }

    protected abstract WebClient.RequestHeadersSpec<?> createRequest(ServiceInstance var1, D var2);

    protected abstract Mono<Void> processResponse(ServerWebExchange var1, GatewayFilterChain var2, R var3);

    protected WebClient.RequestHeadersSpec<?> createRequest(AbstractConfig config, ServerHttpRequest.Builder clientRequestbuilder, ServiceInstance instance, D data, ServerHttpRequest request) {
        WebClient.RequestHeadersSpec<?> zaasCallBuilder = this.createRequest(instance, data);
        clientRequestbuilder.headers(headers -> {
            List cookies = this.readCookies((HttpHeaders)headers).collect(Collectors.toList());
            headers.entrySet().stream().filter(e -> CREDENTIALS_HEADER_INPUT.test((String)e.getKey())).forEach(e -> zaasCallBuilder.header((String)e.getKey(), ((List)e.getValue()).toArray(new String[0])));
            cookies.stream().filter(CREDENTIALS_COOKIE_INPUT).forEach(c -> zaasCallBuilder.cookie(c.getName(), c.getValue()));
            zaasCallBuilder.header(HEADER_SERVICE_ID, new String[]{config.serviceId});
            this.setClientCertificate(zaasCallBuilder, request.getSslInfo());
            Stream nonCredentialHeaders = headers.entrySet().stream().filter(entry -> !CREDENTIALS_HEADER.test((String)entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream().map(v -> new AbstractMap.SimpleEntry(entry.getKey(), (String)v)));
            Stream<Map.Entry> nonCredentialCookies = cookies.stream().filter(c -> !CREDENTIALS_COOKIE.test((HttpCookie)c)).map(c -> new AbstractMap.SimpleEntry<String, String>("Cookie", c.toString()));
            List<Map.Entry> newHeaders = Stream.concat(nonCredentialHeaders, nonCredentialCookies).collect(Collectors.toList());
            headers.clear();
            newHeaders.forEach(newHeader -> headers.add((String)newHeader.getKey(), (String)newHeader.getValue()));
        });
        return zaasCallBuilder;
    }

    protected GatewayFilter createGatewayFilter(AbstractConfig config, D data) {
        return (exchange, chain) -> this.getZaasInstances().flatMap(instances -> {
            ServerHttpRequest.Builder clientCallBuilder = exchange.getRequest().mutate();
            return this.invoke((List<ServiceInstance>)instances, instance -> this.createRequest(config, clientCallBuilder, (ServiceInstance)instance, data, exchange.getRequest()), response -> this.processResponse(exchange.mutate().request(clientCallBuilder.build()).build(), chain, response));
        });
    }

    protected ServerHttpRequest addRequestHeader(ServerWebExchange exchange, String key, String value) {
        return exchange.getRequest().mutate().headers(headers -> headers.add(key, value)).build();
    }

    protected ServerHttpRequest setRequestHeader(ServerWebExchange exchange, String headerName, String headerValue) {
        return exchange.getRequest().mutate().header(headerName, new String[]{headerValue}).build();
    }

    protected ServerHttpRequest updateHeadersForError(ServerWebExchange exchange, String errorMessage) {
        ServerHttpRequest request = this.addRequestHeader(exchange, "X-Zowe-Auth-Failure", errorMessage);
        exchange.getResponse().getHeaders().add("X-Zowe-Auth-Failure", errorMessage);
        return request;
    }

    protected Stream<HttpCookie> readCookies(HttpHeaders httpHeaders) {
        return Optional.ofNullable(httpHeaders.get((Object)"Cookie")).orElse(Collections.emptyList()).stream().map(v -> StringUtils.split((String)v, (String)";")).flatMap(Arrays::stream).map(StringUtils::trim).map(HttpCookie::parse).flatMap(Collection::stream);
    }

    protected void setClientCertificate(WebClient.RequestHeadersSpec<?> callBuilder, SslInfo sslInfo) {
        try {
            String encodedCertificate = X509Util.getEncodedClientCertificate(sslInfo);
            if (encodedCertificate != null) {
                callBuilder.header("Client-Cert", new String[]{encodedCertificate});
            }
        }
        catch (CertificateEncodingException e) {
            callBuilder.header("X-Zowe-Auth-Failure", new String[]{"Invalid client certificate in request. Error message: " + e.getMessage()});
        }
    }

    protected static abstract class AbstractConfig {
        private String serviceId;

        @Generated
        public AbstractConfig() {
        }

        @Generated
        public String getServiceId() {
            return this.serviceId;
        }

        @Generated
        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbstractConfig)) {
                return false;
            }
            AbstractConfig other = (AbstractConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$serviceId = this.getServiceId();
            String other$serviceId = other.getServiceId();
            return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AbstractConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceId = this.getServiceId();
            result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractAuthSchemeFactory.AbstractConfig(serviceId=" + this.getServiceId() + ")";
        }
    }
}

