/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.server.Ssl;
import org.springframework.stereotype.Component;
import org.zowe.apiml.security.SecurityUtils;

@Component
public class SslUpdater
implements BeanPostProcessor {
    private static final String KEYRING_PASSWORD = "password";

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof ServerProperties) {
            ServerProperties serverProperties = (ServerProperties)bean;
            Ssl ssl = serverProperties.getSsl();
            if (SecurityUtils.isKeyring((String)ssl.getKeyStore())) {
                ssl.setKeyStore(SecurityUtils.formatKeyringUrl((String)ssl.getKeyStore()));
                if (StringUtils.isEmpty((String)ssl.getKeyStorePassword())) {
                    ssl.setKeyStorePassword(KEYRING_PASSWORD);
                }
                if (StringUtils.isEmpty((String)ssl.getKeyPassword())) {
                    ssl.setKeyPassword(KEYRING_PASSWORD);
                }
            }
            if (SecurityUtils.isKeyring((String)ssl.getTrustStore())) {
                ssl.setTrustStore(SecurityUtils.formatKeyringUrl((String)ssl.getTrustStore()));
                if (StringUtils.isEmpty((String)ssl.getTrustStorePassword())) {
                    ssl.setTrustStorePassword(KEYRING_PASSWORD);
                }
            }
        }
        return bean;
    }
}

