/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.cloud.gateway.filter.NettyRoutingFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.web.server.ServerWebExchange;
import reactor.netty.http.client.HttpClient;

public class NettyRoutingFilterApiml
extends NettyRoutingFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyRoutingFilterApiml.class);
    private final HttpClient httpClientNoCert;
    private final HttpClient httpClientClientCert;

    public NettyRoutingFilterApiml(HttpClient httpClient, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider, HttpClientProperties properties, SslContext justTruststore, SslContext withKeystore) {
        super(null, headersFiltersProvider, properties);
        this.httpClientNoCert = httpClient.secure(sslContextSpec -> sslContextSpec.sslContext(justTruststore));
        this.httpClientClientCert = httpClient.secure(sslContextSpec -> sslContextSpec.sslContext(withKeystore));
    }

    static Integer getInteger(Object connectTimeoutAttr) {
        Integer connectTimeout = connectTimeoutAttr instanceof Integer ? (Integer)connectTimeoutAttr : Integer.valueOf(Integer.parseInt(connectTimeoutAttr.toString()));
        return connectTimeout;
    }

    protected HttpClient getHttpClient(Route route, ServerWebExchange exchange) {
        boolean useClientCert = Optional.ofNullable((Boolean)exchange.getAttribute("apiml.useClientCert")).orElse(Boolean.FALSE);
        HttpClient httpClient = useClientCert ? this.httpClientClientCert : this.httpClientNoCert;
        log.debug("Using client with keystore {}", (Object)useClientCert);
        Object connectTimeoutAttr = route.getMetadata().get("connect-timeout");
        if (connectTimeoutAttr != null) {
            Integer connectTimeout = NettyRoutingFilterApiml.getInteger(connectTimeoutAttr);
            return (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        }
        return httpClient;
    }
}

