/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service.routing;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.stereotype.Component;
import org.zowe.apiml.cloudgatewayservice.service.routing.RouteDefinitionProducer;
import org.zowe.apiml.product.routing.RoutedService;
import org.zowe.apiml.util.StringUtils;

@Component
public class ByBasePath
extends RouteDefinitionProducer {
    private static final String TARGET_HEADER_NAME = "X-Forward-To";

    public ByBasePath(DiscoveryLocatorProperties properties) {
        super(properties);
    }

    static String constructUrl(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if ((part = StringUtils.removeFirstAndLastOccurrence((String)part, (String)"/")).isEmpty()) continue;
            sb.append('/');
            sb.append(part);
        }
        return sb.toString();
    }

    @Override
    protected void setCondition(RouteDefinition routeDefinition, ServiceInstance serviceInstance, RoutedService routedService) {
        PredicateDefinition headerPredicate = new PredicateDefinition();
        headerPredicate.setName("MissingHeader");
        headerPredicate.addArg("header", TARGET_HEADER_NAME);
        routeDefinition.getPredicates().add(headerPredicate);
        PredicateDefinition pathPredicate = new PredicateDefinition();
        pathPredicate.setName("Path");
        String predicateValue = ByBasePath.constructUrl(serviceInstance.getServiceId(), routedService.getGatewayUrl(), "**");
        pathPredicate.addArg("pattern", predicateValue);
        routeDefinition.getPredicates().add(pathPredicate);
    }

    @Override
    protected void setFilters(RouteDefinition routeDefinition, ServiceInstance serviceInstance, RoutedService routedService) {
        FilterDefinition filter = new FilterDefinition();
        filter.setName("RewritePath");
        filter.addArg("regexp", ByBasePath.constructUrl(serviceInstance.getServiceId(), routedService.getGatewayUrl(), "?(?<remaining>.*)"));
        filter.addArg("replacement", ByBasePath.constructUrl(routedService.getServiceUrl(), "${remaining}"));
        routeDefinition.getFilters().add(filter);
    }

    @Override
    public int getOrder() {
        return 1;
    }
}

