/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import lombok.Generated;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.zowe.apiml.cloudgatewayservice.filters.AbstractAuthSchemeFactory;
import org.zowe.apiml.cloudgatewayservice.service.InstanceInfoService;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.ticket.TicketRequest;

@Service
public abstract class AbstractRequestBodyAuthSchemeFactory<R>
extends AbstractAuthSchemeFactory<Config, R, String> {
    private static final ObjectWriter WRITER = new ObjectMapper().writer();

    public AbstractRequestBodyAuthSchemeFactory(WebClient webClient, InstanceInfoService instanceInfoService, MessageService messageService) {
        super(Config.class, webClient, instanceInfoService, messageService);
    }

    public abstract String getEndpointUrl(ServiceInstance var1);

    @Override
    protected WebClient.RequestHeadersSpec<?> createRequest(ServiceInstance instance, String requestBody) {
        String url = this.getEndpointUrl(instance);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).header("Content-Type", new String[]{"application/json"})).bodyValue((Object)requestBody);
    }

    public GatewayFilter apply(Config config) {
        try {
            return this.createGatewayFilter(config, WRITER.writeValueAsString((Object)new TicketRequest(config.getApplicationName())));
        }
        catch (JsonProcessingException e) {
            return (exchange, chain) -> {
                ServerHttpRequest request = this.updateHeadersForError(exchange, e.getMessage());
                return chain.filter(exchange.mutate().request(request).build());
            };
        }
    }

    public static class Config
    extends AbstractAuthSchemeFactory.AbstractConfig {
        private String applicationName;

        @Generated
        public Config() {
        }

        @Generated
        public String getApplicationName() {
            return this.applicationName;
        }

        @Generated
        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Generated
        public String toString() {
            return "AbstractRequestBodyAuthSchemeFactory.Config(applicationName=" + this.getApplicationName() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$applicationName = this.getApplicationName();
            String other$applicationName = other.getApplicationName();
            return !(this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $applicationName = this.getApplicationName();
            result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
            return result;
        }
    }
}

