/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import lombok.Generated;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.stereotype.Service;

@Service
public class HeaderRouteStepFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public HeaderRouteStepFilterFactory() {
        super(Config.class);
    }

    public GatewayFilter apply(Config config) {
        String header = config.getHeader();
        return (exchange, chain) -> {
            if (exchange.getRequest().getHeaders().containsKey((Object)header)) {
                exchange.mutate().request(request -> exchange.getRequest().mutate().headers(headers -> {
                    String headerValue = headers.getFirst(header);
                    int index = headerValue.indexOf("/");
                    if (index >= 0 && index + 1 < headerValue.length()) {
                        headers.set(header, headerValue.substring(index + 1));
                    } else {
                        headers.remove((Object)header);
                    }
                }));
            }
            return chain.filter(exchange);
        };
    }

    public static class Config {
        private String header;

        @Generated
        public Config() {
        }

        @Generated
        public String getHeader() {
            return this.header;
        }

        @Generated
        public void setHeader(String header) {
            this.header = header;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$header = this.getHeader();
            String other$header = other.getHeader();
            return !(this$header == null ? other$header != null : !this$header.equals(other$header));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HeaderRouteStepFilterFactory.Config(header=" + this.getHeader() + ")";
        }
    }
}

