/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.net.HttpCookie;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.cloudgatewayservice.filters.AbstractAuthSchemeFactory;
import org.zowe.apiml.cloudgatewayservice.service.InstanceInfoService;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.zaas.ZaasTokenResponse;
import reactor.core.publisher.Mono;

public abstract class TokenFilterFactory
extends AbstractAuthSchemeFactory<Config, ZaasTokenResponse, Object> {
    protected TokenFilterFactory(WebClient webClient, InstanceInfoService instanceInfoService, MessageService messageService) {
        super(Config.class, webClient, instanceInfoService, messageService);
    }

    public abstract String getEndpointUrl(ServiceInstance var1);

    public GatewayFilter apply(Config config) {
        try {
            return this.createGatewayFilter(config, null);
        }
        catch (Exception e) {
            return (exchange, chain) -> {
                ServerHttpRequest request = this.updateHeadersForError(exchange, e.getMessage());
                return chain.filter(exchange.mutate().request(request).build());
            };
        }
    }

    @Override
    protected Class<ZaasTokenResponse> getResponseClass() {
        return ZaasTokenResponse.class;
    }

    @Override
    protected ZaasTokenResponse getResponseFor401() {
        return new ZaasTokenResponse();
    }

    @Override
    protected WebClient.RequestHeadersSpec<?> createRequest(ServiceInstance instance, Object data) {
        String tokensUrl = this.getEndpointUrl(instance);
        return this.webClient.post().uri(tokensUrl, new Object[0]);
    }

    @Override
    protected Mono<Void> processResponse(ServerWebExchange exchange, GatewayFilterChain chain, ZaasTokenResponse response) {
        ServerHttpRequest request = null;
        if (response.getToken() != null) {
            if (!StringUtils.isEmpty((CharSequence)response.getCookieName())) {
                request = exchange.getRequest().mutate().headers(headers -> headers.add("Cookie", new HttpCookie(response.getCookieName(), response.getToken()).toString())).build();
            }
            if (!StringUtils.isEmpty((CharSequence)response.getHeaderName())) {
                request = exchange.getRequest().mutate().headers(headers -> headers.add(response.getHeaderName(), response.getToken())).build();
            }
        }
        if (request == null) {
            request = this.updateHeadersForError(exchange, "Invalid or missing authentication");
        }
        exchange = exchange.mutate().request(request).build();
        return chain.filter(exchange);
    }

    public static class Config
    extends AbstractAuthSchemeFactory.AbstractConfig {
        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

