/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.headers.XForwardedHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.product.gateway.AdditionalRegistrationGatewayRegistry;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.SecurityUtils;

public class X509awareXForwardedHeadersFilter
extends XForwardedHeadersFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(X509awareXForwardedHeadersFilter.class);
    public static final String FORWARDED_HEADER = "Forwarded";
    final Set<String> certificateChainBase64;
    final Predicate<String> isProxyTrusted;
    final String trustedProxiesRegex;
    final AtomicReference<Set<String>> trustedAdditionalGateways;

    public X509awareXForwardedHeadersFilter(HttpsConfig httpsConfig, String trustedProxiesPattern, AdditionalRegistrationGatewayRegistry additionalRegistrationGatewayRegistry) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.certificateChainBase64 = SecurityUtils.loadCertificateChainBase64((HttpsConfig)httpsConfig);
        this.trustedProxiesRegex = trustedProxiesPattern;
        this.trustedAdditionalGateways = additionalRegistrationGatewayRegistry.getAdditionalGatewayIpAddressesReference();
        Predicate<String> isTrusted = host -> this.trustedAdditionalGateways.get().contains(host);
        if (StringUtils.isEmpty((String)this.trustedProxiesRegex)) {
            isTrusted = isTrusted.or(host -> false);
        } else {
            Pattern pattern = Pattern.compile(this.trustedProxiesRegex);
            isTrusted = isTrusted.or(host -> host != null && pattern.matcher((CharSequence)host).matches());
        }
        this.isProxyTrusted = isTrusted;
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        if (!this.hasXForwardedHeader(input)) {
            return super.filter(input, exchange);
        }
        boolean trustedSourceByX509 = Optional.ofNullable(exchange.getRequest().getSslInfo()).map(SslInfo::getPeerCertificates).filter(certs -> ((X509Certificate[])certs).length > 0).map(certs -> Arrays.stream(certs).map(SecurityUtils::base64EncodePublicKey).allMatch(this.certificateChainBase64::contains)).orElse(false);
        if (!trustedSourceByX509) {
            ServerHttpRequest request = exchange.getRequest();
            InetSocketAddress remoteAddress = request.getRemoteAddress();
            if (remoteAddress == null) {
                log.trace("Remote address is null and cannot be evaluated for trusted proxy.");
                return super.filter(this.removeXForwardHttpHeaders(input), exchange);
            }
            if (!this.isProxyTrusted.test(remoteAddress.getHostString())) {
                ServerWebExchange sanitizedExchange = exchange.mutate().request((ServerHttpRequest)new ServerHttpRequestDecorator(request){

                    public InetSocketAddress getRemoteAddress() {
                        return null;
                    }
                }).build();
                log.trace("Remote address not trusted. Trusted proxies pattern: {}, remote address: {}", (Object)this.trustedProxiesRegex, (Object)remoteAddress);
                return super.filter(this.removeXForwardHttpHeaders(input), sanitizedExchange);
            }
        }
        return super.filter(input, exchange);
    }

    private HttpHeaders removeXForwardHttpHeaders(HttpHeaders input) {
        HttpHeaders h = new HttpHeaders();
        input.forEach((header, values) -> {
            if (!this.isXForwardedHeader((String)header)) {
                h.put(header, values);
            }
        });
        return h;
    }

    private boolean isXForwardedHeader(String header) {
        return header.equalsIgnoreCase("X-Forwarded-For") || header.equalsIgnoreCase("X-Forwarded-Host") || header.equalsIgnoreCase("X-Forwarded-Port") || header.equalsIgnoreCase("X-Forwarded-Proto") || header.equalsIgnoreCase("X-Forwarded-Prefix") || header.equalsIgnoreCase(FORWARDED_HEADER);
    }

    private boolean hasXForwardedHeader(HttpHeaders headers) {
        return headers.keySet().stream().anyMatch(this::isXForwardedHeader);
    }
}

