/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.controller;

import com.google.common.base.Strings;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.cloudgatewayservice.service.CentralApimlInfoMapper;
import org.zowe.apiml.cloudgatewayservice.service.GatewayIndexService;
import org.zowe.apiml.cloudgatewayservice.service.model.ApimlInfo;
import org.zowe.apiml.services.ServiceInfo;
import reactor.core.publisher.Flux;

@RestController
@Tag(name="Central Registry")
@RequestMapping(value={"cloud-gateway/api/v1"}, produces={"application/json"})
@ConditionalOnProperty(value={"apiml.cloudGateway.registry.enabled"}, havingValue="true")
public class RegistryController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistryController.class);
    private final CentralApimlInfoMapper centralApimlInfoMapper;
    private final GatewayIndexService gatewayIndexService;

    @GetMapping(value={"/registry", "/registry/{apimlId}"})
    public Flux<ApimlInfo> getServices(@PathVariable(required=false) String apimlId, @RequestParam(name="apiId", required=false) String apiId, @RequestParam(name="serviceId", required=false) String serviceId) {
        Map<String, List<ServiceInfo>> apimlList = this.gatewayIndexService.listRegistry(Strings.emptyToNull((String)apimlId), Strings.emptyToNull((String)apiId), Strings.emptyToNull((String)serviceId));
        return Flux.fromIterable(apimlList.entrySet()).map(this::buildEntry).onErrorContinue(RuntimeException.class, (ex, consumer) -> log.debug("Unexpected mapping error", ex));
    }

    private ApimlInfo buildEntry(Map.Entry<String, List<ServiceInfo>> entry) {
        return this.centralApimlInfoMapper.buildApimlServiceInfo(entry.getKey(), entry.getValue());
    }

    @Generated
    public RegistryController(CentralApimlInfoMapper centralApimlInfoMapper, GatewayIndexService gatewayIndexService) {
        this.centralApimlInfoMapper = centralApimlInfoMapper;
        this.gatewayIndexService = gatewayIndexService;
    }
}

