/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.headers.XForwardedHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.SecurityUtils;

public class X509awareXForwardedHeadersFilter
extends XForwardedHeadersFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(X509awareXForwardedHeadersFilter.class);
    public static final String FORWARDED_HEADER = "Forwarded";
    final Set<String> certificateChainBase64;
    final Predicate<String> isTrusted;
    final String trustedProxies;

    public X509awareXForwardedHeadersFilter(HttpsConfig httpsConfig, String trustedProxiesPattern) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.certificateChainBase64 = SecurityUtils.loadCertificateChainBase64((HttpsConfig)httpsConfig);
        this.trustedProxies = trustedProxiesPattern;
        if (StringUtils.isEmpty((String)this.trustedProxies)) {
            this.isTrusted = host -> false;
        } else {
            Pattern pattern = Pattern.compile(this.trustedProxies);
            this.isTrusted = host -> host != null && pattern.matcher((CharSequence)host).matches();
        }
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        boolean trustedSourceByX509 = Optional.ofNullable(exchange.getRequest().getSslInfo()).map(SslInfo::getPeerCertificates).filter(certs -> ((X509Certificate[])certs).length > 0).map(certs -> Arrays.stream(certs).map(SecurityUtils::base64EncodePublicKey).allMatch(this.certificateChainBase64::contains)).orElse(false);
        if (!trustedSourceByX509) {
            ServerHttpRequest request = exchange.getRequest();
            InetSocketAddress remoteAddress = request.getRemoteAddress();
            if (remoteAddress == null) {
                log.trace("Remote address is null and cannot be evaluated for trusted proxy.");
                return super.filter(this.removeXForwardHttpHeaders(input), exchange);
            }
            if (!this.isTrusted.test(remoteAddress.getHostString())) {
                ServerWebExchange sanitizedExchange = exchange.mutate().request((ServerHttpRequest)new ServerHttpRequestDecorator(request){

                    public InetSocketAddress getRemoteAddress() {
                        return null;
                    }
                }).build();
                log.trace("Remote address not trusted. Trusted proxies pattern: {}, remote address: {}", (Object)this.trustedProxies, (Object)remoteAddress);
                return super.filter(this.removeXForwardHttpHeaders(input), sanitizedExchange);
            }
        }
        return super.filter(input, exchange);
    }

    private HttpHeaders removeXForwardHttpHeaders(HttpHeaders input) {
        HttpHeaders h = new HttpHeaders();
        input.forEach((header, values) -> {
            if (!this.isXForwardedHeader((String)header)) {
                h.put(header, values);
            }
        });
        return h;
    }

    private boolean isXForwardedHeader(String header) {
        return header.equalsIgnoreCase("X-Forwarded-For") || header.equalsIgnoreCase("X-Forwarded-Host") || header.equalsIgnoreCase("X-Forwarded-Port") || header.equalsIgnoreCase("X-Forwarded-Proto") || header.equalsIgnoreCase("X-Forwarded-Prefix") || header.equalsIgnoreCase(FORWARDED_HEADER);
    }
}

