/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.Certificate;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.zowe.apiml.cloudgatewayservice.config.ConnectionsConfig;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsConfigError;
import org.zowe.apiml.security.SecurityUtils;

@Service
public class CertificateChainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateChainService.class);
    private static final ApimlLogger apimlLog = ApimlLogger.of(CertificateChainService.class, (MessageService)YamlMessageServiceInstance.getInstance());
    Certificate[] certificates;
    private final ConnectionsConfig connectionsConfig;

    public String getCertificatesInPEMFormat() {
        StringWriter stringWriter = new StringWriter();
        if (this.certificates != null && this.certificates.length > 0) {
            try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)stringWriter);){
                for (Certificate cert : this.certificates) {
                    jcaPEMWriter.writeObject((Object)cert);
                }
            }
            catch (IOException e) {
                log.error("Failed to convert a certificate to PEM format. {}", (Object)e.getMessage());
                return null;
            }
        }
        return stringWriter.toString();
    }

    @PostConstruct
    void loadCertChain() {
        HttpsConfig config = this.connectionsConfig.factory().getConfig();
        try {
            this.certificates = SecurityUtils.loadCertificateChain((HttpsConfig)config);
        }
        catch (Exception e) {
            apimlLog.log("org.zowe.apiml.common.sslContextInitializationError", new Object[]{e.getMessage()});
            throw new HttpsConfigError("Error initializing SSL Context: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, config);
        }
    }

    @Generated
    public CertificateChainService(ConnectionsConfig connectionsConfig) {
        this.connectionsConfig = connectionsConfig;
    }
}

