/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service.routing;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.stereotype.Component;
import org.zowe.apiml.cloudgatewayservice.service.routing.RouteDefinitionProducer;
import org.zowe.apiml.product.routing.RoutedService;

@Component
public class ByHeader
extends RouteDefinitionProducer {
    private static final String TARGET_HEADER_NAME = "X-Forward-To";

    public ByHeader(DiscoveryLocatorProperties properties) {
        super(properties);
    }

    @Override
    protected void setCondition(RouteDefinition routeDefinition, ServiceInstance serviceInstance, RoutedService routedService) {
        PredicateDefinition predicate = new PredicateDefinition();
        predicate.setName("Header");
        predicate.addArg("header", TARGET_HEADER_NAME);
        predicate.addArg("regexp", serviceInstance.getServiceId() + "(/.*)?");
        routeDefinition.getPredicates().add(predicate);
    }

    @Override
    protected void setFilters(RouteDefinition routeDefinition, ServiceInstance serviceInstance, RoutedService routedService) {
        FilterDefinition filter = new FilterDefinition();
        filter.setName("HeaderRouteStepFilterFactory");
        filter.addArg("header", TARGET_HEADER_NAME);
        routeDefinition.getFilters().add(filter);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

