/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.health;

import com.netflix.discovery.shared.Application;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.zowe.apiml.caching.health.CachesHealthIndicator;
import org.zowe.apiml.eurekaservice.client.ApiMediationClient;
import org.zowe.apiml.product.constants.CoreService;

@Component
@ConditionalOnMissingBean(name={"modulithConfig"})
public class CachingHealthIndicator
extends AbstractHealthIndicator
implements ApplicationListener<ApplicationReadyEvent> {
    private final AtomicReference<Boolean> serviceUp = new AtomicReference<Boolean>(false);
    private final ApiMediationClient apiMediationClient;
    private final Optional<CachesHealthIndicator> cachesHealthIndicator;

    protected void doHealthCheck(Health.Builder builder) {
        boolean gatewayUp = Optional.ofNullable(this.apiMediationClient.getEurekaClient()).map(eurekaClient -> eurekaClient.getApplication(CoreService.GATEWAY.getServiceId())).map(Application::getInstances).map(i -> !i.isEmpty()).orElse(false);
        builder.withDetail(CoreService.GATEWAY.getServiceId(), (Object)(gatewayUp ? Status.UP : Status.DOWN));
        this.cachesHealthIndicator.ifPresent(i -> i.doHealthCheck(builder));
        if (!this.serviceUp.get().booleanValue() || !gatewayUp) {
            builder.down();
        }
    }

    public void onApplicationEvent(@Nonnull ApplicationReadyEvent event) {
        this.serviceUp.set(true);
    }

    @Generated
    public CachingHealthIndicator(ApiMediationClient apiMediationClient, Optional<CachesHealthIndicator> cachesHealthIndicator) {
        this.apiMediationClient = apiMediationClient;
        this.cachesHealthIndicator = cachesHealthIndicator;
    }
}

