/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.infinispan.config;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.partitionhandling.AvailabilityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.zowe.apiml.cache.Storage;
import org.zowe.apiml.cache.StorageException;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.infinispan.exception.InfinispanConfigException;
import org.zowe.apiml.caching.service.infinispan.storage.InfinispanStorage;
import org.zowe.apiml.security.SecurityUtils;

@Configuration
@ConfigurationProperties(value="caching.storage.infinispan")
@ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="infinispan")
public class InfinispanConfig
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InfinispanConfig.class);
    private static final String KEYRING_PASSWORD = "password";
    private static final String SERVER_SSL_KEY_STORE_TYPE = "server.ssl.keyStoreType";
    private static final String SERVER_SSL_KEY_STORE = "server.ssl.keyStore";
    private static final String SERVER_SSL_KEY_STORE_PASSWORD = "server.ssl.keyStorePassword";
    private static final String ZWE_HAINSTANCE_ID = "ZWE_haInstance_id";
    private static final String LOCK_ZOWE_INVALIDATED = "zoweInvalidatedTokenLock";
    private static final String CACHE_ZOWE = "zoweCache";
    private static final String CACHE_ZOWE_INVALIDATED_TOKEN = "zoweInvalidatedTokenCache";
    @Value(value="${caching.storage.infinispan.initialHosts}")
    private String initialHosts;
    @Value(value="${server.ssl.keyStoreType}")
    private String keyStoreType;
    @Value(value="${server.ssl.keyStore}")
    private String keyStore;
    @Value(value="${server.ssl.keyStorePassword}")
    private String keyStorePass;
    @Value(value="${jgroups.bind.port}")
    private String port;
    @Value(value="${jgroups.bind.address}")
    private String address;
    @Value(value="${jgroups.keyExchange.port:7601}")
    private String keyExchangePort;
    @Value(value="${jgroups.tcp.diag.enabled:false}")
    private String tcpDiagEnabled;
    @Value(value="${server.attlsServer.enabled:false}")
    private boolean isServerAttlsEnabled;
    private AtomicReference<ClusteredLock> zoweInvalidatedTokenLock = new AtomicReference();

    public void afterPropertiesSet() {
        this.updateKeyring();
    }

    @PostConstruct
    void updateKeyring() {
        if (SecurityUtils.isKeyring((String)this.keyStore)) {
            this.keyStore = SecurityUtils.formatKeyringUrl((String)this.keyStore);
            if (StringUtils.isBlank((CharSequence)this.keyStorePass)) {
                this.keyStorePass = KEYRING_PASSWORD;
            }
        }
    }

    static String getRootFolder() {
        String workspaceFolder;
        String instanceId = System.getenv().get(ZWE_HAINSTANCE_ID);
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            instanceId = "localhost";
        }
        if (StringUtils.isBlank((CharSequence)(workspaceFolder = System.getenv().get("ZWE_zowe_workspaceDirectory")))) {
            return Paths.get("caching-service", instanceId).toString();
        }
        return Paths.get(workspaceFolder, "caching-service", instanceId).toString();
    }

    @Bean(destroyMethod="stop")
    synchronized DefaultCacheManager cacheManager(ResourceLoader resourceLoader) {
        ConfigurationBuilderHolder holder;
        System.setProperty("jgroups.tcpping.initial_hosts", this.initialHosts);
        System.setProperty("jgroups.bind.port", this.port);
        System.setProperty("jgroups.bind.address", this.address);
        System.setProperty("jgroups.keyExchange.port", this.keyExchangePort);
        System.setProperty("jgroups.tcp.diag.enabled", String.valueOf(Boolean.parseBoolean(this.tcpDiagEnabled)));
        Optional<String> oldKeyStoreType = Optional.ofNullable(System.getProperty(SERVER_SSL_KEY_STORE_TYPE));
        Optional<String> oldKeyStore = Optional.ofNullable(System.getProperty(SERVER_SSL_KEY_STORE));
        Optional<String> oldKeyStorePassword = Optional.ofNullable(System.getProperty(SERVER_SSL_KEY_STORE_PASSWORD));
        if (!this.isServerAttlsEnabled) {
            System.setProperty(SERVER_SSL_KEY_STORE_TYPE, this.keyStoreType);
            System.setProperty(SERVER_SSL_KEY_STORE, this.keyStore);
            System.setProperty(SERVER_SSL_KEY_STORE_PASSWORD, this.keyStorePass);
        }
        String infinispanConfigFile = this.isServerAttlsEnabled ? "infinispan-attls.xml" : "infinispan.xml";
        try (InputStream configurationStream = resourceLoader.getResource("classpath:" + infinispanConfigFile).getInputStream();){
            holder = new ParserRegistry().parse(configurationStream, MediaType.APPLICATION_XML);
        }
        catch (IOException e) {
            throw new InfinispanConfigException("Can't read configuration file", e);
        }
        holder.getGlobalConfigurationBuilder().globalState().persistentLocation(InfinispanConfig.getRootFolder()).enable();
        holder.newConfigurationBuilder("default").persistence().addSoftIndexFileStore().clustering().cacheMode(CacheMode.DIST_SYNC);
        DefaultCacheManager cacheManager = new DefaultCacheManager(holder, true);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().mediaType("application/x-jboss-marshalling").persistence().addSoftIndexFileStore().clustering().clustering().cacheMode(CacheMode.DIST_SYNC);
        List<String> caches = Arrays.asList(CACHE_ZOWE, CACHE_ZOWE_INVALIDATED_TOKEN, "zosmfAuthenticationEndpoint", "invalidatedJwtTokens", "validationJwtToken", "zosmfInfo", "zosmfJwtEndpoint", "trustedCertificates", "parseOIDCToken", "validationOIDCToken");
        caches.forEach(cacheName -> ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache(cacheName, builder.build()));
        oldKeyStoreType.ifPresent(kst -> System.setProperty(SERVER_SSL_KEY_STORE_TYPE, kst));
        oldKeyStore.ifPresent(ks -> System.setProperty(SERVER_SSL_KEY_STORE, ks));
        oldKeyStorePassword.ifPresent(p -> System.setProperty(SERVER_SSL_KEY_STORE_PASSWORD, p));
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusteredLock lock(DefaultCacheManager cacheManager) {
        ClusteredLock lock = this.zoweInvalidatedTokenLock.get();
        if (lock != null) {
            return lock;
        }
        try {
            AtomicReference<ClusteredLock> atomicReference = this.zoweInvalidatedTokenLock;
            synchronized (atomicReference) {
                lock = this.zoweInvalidatedTokenLock.get();
                if (lock == null) {
                    ClusteredLockManager clm = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)cacheManager);
                    clm.defineLock(LOCK_ZOWE_INVALIDATED);
                    lock = clm.get(LOCK_ZOWE_INVALIDATED);
                }
                this.zoweInvalidatedTokenLock.set(lock);
            }
            return lock;
        }
        catch (AvailabilityException ae) {
            log.debug("Cannot obtain lock", (Throwable)ae);
            throw new StorageException(Messages.CACHE_NOT_AVAILABLE.getKey(), Messages.CACHE_NOT_AVAILABLE.getStatus(), new String[]{ae.getMessage()});
        }
    }

    @Bean
    public Storage storage(DefaultCacheManager cacheManager) {
        return new InfinispanStorage((ConcurrentMap<String, KeyValue>)cacheManager.getCache(CACHE_ZOWE), (ConcurrentMap<String, Map<String, String>>)cacheManager.getCache(CACHE_ZOWE_INVALIDATED_TOKEN), () -> this.lock(cacheManager));
    }
}

