/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import lombok.Generated;
import org.zowe.apiml.caching.service.vsam.JzosImplementationException;
import org.zowe.apiml.caching.service.vsam.VsamRecordException;
import org.zowe.apiml.caching.service.vsam.config.VsamConfig;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.util.ClassOrDefaultProxyUtils;
import org.zowe.apiml.zfile.EnqueueException;
import org.zowe.apiml.zfile.RcException;
import org.zowe.apiml.zfile.ZFile;
import org.zowe.apiml.zfile.ZFileDummyImpl;
import org.zowe.apiml.zfile.ZFileException;

public class ZFileProducer {
    private static final Pattern REGEX_CORRECT_FILENAME = Pattern.compile("^//'.*'");
    private final VsamConfig vsamConfig;
    private final VsamConfig.VsamOptions options;
    private final ApimlLogger apimlLog;

    public ZFile openZfile() throws VsamRecordException {
        if (!REGEX_CORRECT_FILENAME.matcher(this.vsamConfig.getFileName()).find()) {
            throw new IllegalStateException("VsamFile does not exist");
        }
        String calledMethod = "getMessage";
        try {
            return (ZFile)ClassOrDefaultProxyUtils.createProxyByConstructor(ZFile.class, (String)"com.ibm.jzos.ZFile", ZFileDummyImpl::new, (Class[])new Class[]{String.class, String.class, Integer.TYPE}, (Object[])new Object[]{this.vsamConfig.getFileName(), this.options.getOptionsString(), 3}, (ClassOrDefaultProxyUtils.ExceptionMapping[])new ClassOrDefaultProxyUtils.ExceptionMapping[]{new ClassOrDefaultProxyUtils.ByMethodName("com.ibm.jzos.ZFileException", ZFileException.class, new String[]{"getFileName", calledMethod, "getErrnoMsg", "getErrno", "getErrno2", "getLastOp", "getAmrcBytes", "getAbendCode", "getAbendRc", "getFeedbackRc", "getFeedbackFtncd", "getFeedbackFdbk"}), new ClassOrDefaultProxyUtils.ByMethodName("com.ibm.jzos.RcException", RcException.class, new String[]{calledMethod, "getRc"}), new ClassOrDefaultProxyUtils.ByMethodName("com.ibm.jzos.EnqueueException", EnqueueException.class, new String[]{calledMethod, "getRc"})});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            this.apimlLog.log("org.zowe.apiml.cache.noJzosImplementation", new Object[0]);
            throw new JzosImplementationException(e);
        }
        catch (InvocationTargetException e) {
            throw new VsamRecordException("Failed opening of file", e.getTargetException());
        }
    }

    @Generated
    public ZFileProducer(VsamConfig vsamConfig, VsamConfig.VsamOptions options, ApimlLogger apimlLog) {
        this.vsamConfig = vsamConfig;
        this.options = options;
        this.apimlLog = apimlLog;
    }
}

