/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import lombok.Generated;
import org.springframework.stereotype.Service;
import org.zowe.apiml.caching.config.GeneralConfig;
import org.zowe.apiml.caching.service.EvictionStrategy;
import org.zowe.apiml.caching.service.RejectStrategy;
import org.zowe.apiml.caching.service.Strategies;
import org.zowe.apiml.caching.service.vsam.RemoveOldestStrategy;
import org.zowe.apiml.caching.service.vsam.VsamFile;
import org.zowe.apiml.caching.service.vsam.config.VsamConfig;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;

@Service
public class EvictionStrategyProducer {
    private final GeneralConfig generalConfig;
    private final VsamConfig vsamConfig;
    private final MessageService messageService;
    private RejectStrategy rejectStrategy;

    EvictionStrategy evictionStrategy(VsamFile vsamFile) {
        if (this.generalConfig.getEvictionStrategy().equals(Strategies.REJECT.getKey())) {
            if (this.rejectStrategy == null) {
                this.rejectStrategy = new RejectStrategy(ApimlLogger.of(RejectStrategy.class, (MessageService)this.messageService));
            }
            return this.rejectStrategy;
        }
        return new RemoveOldestStrategy(this.vsamConfig, vsamFile);
    }

    @Generated
    public EvictionStrategyProducer(GeneralConfig generalConfig, VsamConfig vsamConfig, MessageService messageService) {
        this.generalConfig = generalConfig;
        this.vsamConfig = vsamConfig;
        this.messageService = messageService;
    }
}

