/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import java.io.UnsupportedEncodingException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.caching.service.EvictionStrategy;
import org.zowe.apiml.caching.service.vsam.VsamFile;
import org.zowe.apiml.caching.service.vsam.VsamRecord;
import org.zowe.apiml.caching.service.vsam.VsamRecordException;
import org.zowe.apiml.caching.service.vsam.config.VsamConfig;
import org.zowe.apiml.zfile.ZFileException;

public class RemoveOldestStrategy
implements EvictionStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoveOldestStrategy.class);
    private final VsamConfig vsamConfig;
    private final VsamFile file;

    @Override
    public void evict(String key) {
        this.removeOldestRecord();
    }

    private void removeOldestRecord() {
        VsamRecord oldest = null;
        try {
            Optional<byte[]> readRecord;
            byte[] ignoreKey = " ".getBytes("IBM-1047");
            byte[] recBuf = new byte[this.vsamConfig.getRecordLength()];
            int overflowProtection = 10000;
            this.file.getZfile().locate(ignoreKey, 1);
            while ((readRecord = this.file.readBytes(recBuf)).isPresent()) {
                long currentCreated;
                long oldestCreated;
                VsamRecord current = new VsamRecord(this.vsamConfig, readRecord.get());
                if (oldest == null) {
                    oldest = current;
                }
                if ((oldestCreated = Long.parseLong(oldest.getKeyValue().getCreated())) > (currentCreated = Long.parseLong(current.getKeyValue().getCreated()))) {
                    oldest = current;
                }
                if (--overflowProtection > 0) continue;
                log.info("Maximum number of records retrieved, stopping the retrieval");
                break;
            }
        }
        catch (UnsupportedEncodingException | VsamRecordException | ZFileException e) {
            log.info(e.toString());
        }
        this.checkAndRemoveRecord(oldest);
    }

    private void checkAndRemoveRecord(VsamRecord oldest) {
        if (oldest != null) {
            log.info("Removing the oldest record {}", (Object)oldest.getKeyValue().getKey());
            Optional<VsamRecord> returned = this.file.delete(oldest);
            if (returned.isPresent()) {
                log.info("The oldest record has been successfully removed!");
            }
        }
        log.info("It was not possible to delete the record.");
    }

    @Generated
    public RemoveOldestStrategy(VsamConfig vsamConfig, VsamFile file) {
        this.vsamConfig = vsamConfig;
        this.file = file;
    }
}

