/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.config;

import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.zowe.apiml.filter.AttlsFilter;
import org.zowe.apiml.filter.SecureConnectionFilter;

@Configuration
@EnableWebSecurity
public class SpringSecurityConfig {
    @Value(value="${apiml.service.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifyCertificates;
    @Value(value="${apiml.service.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifyCerts;
    @Value(value="${server.attls.enabled:false}")
    private boolean isAttlsEnabled;
    @Value(value="${apiml.metrics.enabled:false}")
    private boolean isMetricsEnabled;

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        String[] noSecurityAntMatchers = new String[]{"/application/health", "/application/info", "/v3/api-docs"};
        return web -> {
            web.ignoring().antMatchers(noSecurityAntMatchers);
            if (this.isMetricsEnabled) {
                web.ignoring().antMatchers(new String[]{"/application/hystrixstream"});
            }
        };
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.csrf(csrf -> csrf.disable()).headers(headers -> headers.httpStrictTransportSecurity().disable()).sessionManagement(management -> management.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        if (this.verifyCertificates || !this.nonStrictVerifyCerts) {
            http.authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated()).x509(x509 -> x509.userDetailsService(this.x509UserDetailsService()));
            if (this.isAttlsEnabled) {
                http.addFilterBefore((Filter)new AttlsFilter(), X509AuthenticationFilter.class);
                http.addFilterBefore((Filter)new SecureConnectionFilter(), AttlsFilter.class);
            }
        } else {
            http.authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).permitAll());
        }
        return (SecurityFilterChain)http.build();
    }

    private UserDetailsService x509UserDetailsService() {
        return username -> new User("cachingUser", "", Collections.emptyList());
    }
}

