/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.redis.config;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.caching.config.GeneralConfig;

@Configuration
@ConfigurationProperties(value="caching.storage.redis")
@ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="redis")
public class RedisConfig {
    private static final int DEFAULT_PORT = 6379;
    private static final String DEFAULT_USER = "default";
    private static final char[] DEFAULT_PASSWORD = "".toCharArray();
    private static final String AUTHENTICATION_SEPARATOR = "@";
    private static final String PORT_SEPARATOR = ":";
    private static final char CREDENTIALS_SEPARATOR = ':';
    private Integer timeout = 60;
    private String masterNodeUri;
    private final GeneralConfig generalConfig;
    private String host;
    private Integer port = 6379;
    private String username = "default";
    private char[] password = DEFAULT_PASSWORD;
    private Sentinel sentinel;
    private SslConfig ssl;

    @PostConstruct
    public void init() {
        NodeUriCredentials credentials = RedisConfig.parseCredentialsFromUri(this.masterNodeUri);
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
        this.port = RedisConfig.parsePortFromUri(this.masterNodeUri);
        this.host = RedisConfig.parseHostFromUri(this.masterNodeUri);
    }

    public boolean usesSentinel() {
        return this.sentinel != null && this.sentinel.isEnabled();
    }

    public boolean usesSsl() {
        return this.ssl != null && this.ssl.getEnabled() != false;
    }

    private static boolean uriContainsCredentials(String nodeUri) {
        return nodeUri.contains(AUTHENTICATION_SEPARATOR);
    }

    private static boolean uriContainsPort(String nodeUri) {
        if (RedisConfig.uriContainsCredentials(nodeUri)) {
            return nodeUri.substring(nodeUri.indexOf(AUTHENTICATION_SEPARATOR) + 1).contains(PORT_SEPARATOR);
        }
        return nodeUri.contains(PORT_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NodeUriCredentials parseCredentialsFromUri(String nodeUri) {
        if (!RedisConfig.uriContainsCredentials(nodeUri)) {
            return new NodeUriCredentials(DEFAULT_USER, DEFAULT_PASSWORD);
        }
        String credentials = nodeUri.substring(0, nodeUri.indexOf(AUTHENTICATION_SEPARATOR));
        char[] credentialsChars = null;
        try {
            credentialsChars = credentials.toCharArray();
            int index = ArrayUtils.indexOf((char[])credentialsChars, (char)':');
            if (index >= 0) {
                NodeUriCredentials nodeUriCredentials = new NodeUriCredentials(credentials.substring(0, index), Arrays.copyOfRange(credentialsChars, index + 1, credentialsChars.length));
                return nodeUriCredentials;
            }
            NodeUriCredentials output = new NodeUriCredentials(DEFAULT_USER, credentialsChars);
            credentialsChars = null;
            NodeUriCredentials nodeUriCredentials = output;
            return nodeUriCredentials;
        }
        finally {
            if (credentialsChars != null) {
                Arrays.fill(credentialsChars, '\u0000');
            }
        }
    }

    private static String parseHostFromUri(String nodeUri) {
        if (RedisConfig.uriContainsCredentials(nodeUri)) {
            if (RedisConfig.uriContainsPort(nodeUri)) {
                String hostAndPort = nodeUri.substring(nodeUri.indexOf(AUTHENTICATION_SEPARATOR) + 1);
                return hostAndPort.substring(0, hostAndPort.indexOf(PORT_SEPARATOR));
            }
            return nodeUri.substring(nodeUri.indexOf(AUTHENTICATION_SEPARATOR) + 1);
        }
        if (RedisConfig.uriContainsPort(nodeUri)) {
            return nodeUri.substring(0, nodeUri.indexOf(PORT_SEPARATOR));
        }
        return nodeUri;
    }

    private static int parsePortFromUri(String nodeUri) {
        if (!RedisConfig.uriContainsPort(nodeUri)) {
            return 6379;
        }
        if (RedisConfig.uriContainsCredentials(nodeUri)) {
            String hostAndPort = nodeUri.substring(nodeUri.indexOf(AUTHENTICATION_SEPARATOR) + 1);
            return Integer.parseInt(hostAndPort.substring(hostAndPort.indexOf(PORT_SEPARATOR) + 1));
        }
        return Integer.parseInt(nodeUri.substring(nodeUri.indexOf(PORT_SEPARATOR) + 1));
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getMasterNodeUri() {
        return this.masterNodeUri;
    }

    @Generated
    public GeneralConfig getGeneralConfig() {
        return this.generalConfig;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public Sentinel getSentinel() {
        return this.sentinel;
    }

    @Generated
    public SslConfig getSsl() {
        return this.ssl;
    }

    @Generated
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setMasterNodeUri(String masterNodeUri) {
        this.masterNodeUri = masterNodeUri;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setSentinel(Sentinel sentinel) {
        this.sentinel = sentinel;
    }

    @Generated
    public void setSsl(SslConfig ssl) {
        this.ssl = ssl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisConfig)) {
            return false;
        }
        RedisConfig other = (RedisConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$masterNodeUri = this.getMasterNodeUri();
        String other$masterNodeUri = other.getMasterNodeUri();
        if (this$masterNodeUri == null ? other$masterNodeUri != null : !this$masterNodeUri.equals(other$masterNodeUri)) {
            return false;
        }
        GeneralConfig this$generalConfig = this.getGeneralConfig();
        GeneralConfig other$generalConfig = other.getGeneralConfig();
        if (this$generalConfig == null ? other$generalConfig != null : !((Object)this$generalConfig).equals(other$generalConfig)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        Sentinel this$sentinel = this.getSentinel();
        Sentinel other$sentinel = other.getSentinel();
        if (this$sentinel == null ? other$sentinel != null : !((Object)this$sentinel).equals(other$sentinel)) {
            return false;
        }
        SslConfig this$ssl = this.getSsl();
        SslConfig other$ssl = other.getSsl();
        return !(this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedisConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $masterNodeUri = this.getMasterNodeUri();
        result = result * 59 + ($masterNodeUri == null ? 43 : $masterNodeUri.hashCode());
        GeneralConfig $generalConfig = this.getGeneralConfig();
        result = result * 59 + ($generalConfig == null ? 43 : ((Object)$generalConfig).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        Sentinel $sentinel = this.getSentinel();
        result = result * 59 + ($sentinel == null ? 43 : ((Object)$sentinel).hashCode());
        SslConfig $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RedisConfig(timeout=" + this.getTimeout() + ", masterNodeUri=" + this.getMasterNodeUri() + ", generalConfig=" + this.getGeneralConfig() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", sentinel=" + this.getSentinel() + ", ssl=" + this.getSsl() + ")";
    }

    @Generated
    public RedisConfig(GeneralConfig generalConfig) {
        this.generalConfig = generalConfig;
    }

    private static class NodeUriCredentials {
        private String username;
        private char[] password;

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public char[] getPassword() {
            return this.password;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(char[] password) {
            this.password = password;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeUriCredentials)) {
                return false;
            }
            NodeUriCredentials other = (NodeUriCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            return Arrays.equals(this.getPassword(), other.getPassword());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NodeUriCredentials;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            result = result * 59 + Arrays.hashCode(this.getPassword());
            return result;
        }

        @Generated
        public String toString() {
            return "RedisConfig.NodeUriCredentials(username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ")";
        }

        @Generated
        public NodeUriCredentials(String username, char[] password) {
            this.username = username;
            this.password = password;
        }
    }

    public static class SslConfig {
        private Boolean enabled = true;
        private String keyStore;
        private String keyStorePassword;
        private String trustStore;
        private String trustStorePassword;

        @Generated
        public SslConfig() {
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getKeyStore() {
            return this.keyStore;
        }

        @Generated
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        @Generated
        public String getTrustStore() {
            return this.trustStore;
        }

        @Generated
        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        @Generated
        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Generated
        public void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        @Generated
        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SslConfig)) {
                return false;
            }
            SslConfig other = (SslConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$keyStore = this.getKeyStore();
            String other$keyStore = other.getKeyStore();
            if (this$keyStore == null ? other$keyStore != null : !this$keyStore.equals(other$keyStore)) {
                return false;
            }
            String this$keyStorePassword = this.getKeyStorePassword();
            String other$keyStorePassword = other.getKeyStorePassword();
            if (this$keyStorePassword == null ? other$keyStorePassword != null : !this$keyStorePassword.equals(other$keyStorePassword)) {
                return false;
            }
            String this$trustStore = this.getTrustStore();
            String other$trustStore = other.getTrustStore();
            if (this$trustStore == null ? other$trustStore != null : !this$trustStore.equals(other$trustStore)) {
                return false;
            }
            String this$trustStorePassword = this.getTrustStorePassword();
            String other$trustStorePassword = other.getTrustStorePassword();
            return !(this$trustStorePassword == null ? other$trustStorePassword != null : !this$trustStorePassword.equals(other$trustStorePassword));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SslConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $keyStore = this.getKeyStore();
            result = result * 59 + ($keyStore == null ? 43 : $keyStore.hashCode());
            String $keyStorePassword = this.getKeyStorePassword();
            result = result * 59 + ($keyStorePassword == null ? 43 : $keyStorePassword.hashCode());
            String $trustStore = this.getTrustStore();
            result = result * 59 + ($trustStore == null ? 43 : $trustStore.hashCode());
            String $trustStorePassword = this.getTrustStorePassword();
            result = result * 59 + ($trustStorePassword == null ? 43 : $trustStorePassword.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RedisConfig.SslConfig(enabled=" + this.getEnabled() + ", keyStore=" + this.getKeyStore() + ", keyStorePassword=" + this.getKeyStorePassword() + ", trustStore=" + this.getTrustStore() + ", trustStorePassword=" + this.getTrustStorePassword() + ")";
        }
    }

    public static class Sentinel {
        private boolean enabled = false;
        private String masterInstance;
        private List<SentinelNode> nodes;

        @Generated
        public Sentinel() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getMasterInstance() {
            return this.masterInstance;
        }

        @Generated
        public List<SentinelNode> getNodes() {
            return this.nodes;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setMasterInstance(String masterInstance) {
            this.masterInstance = masterInstance;
        }

        @Generated
        public void setNodes(List<SentinelNode> nodes) {
            this.nodes = nodes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sentinel)) {
                return false;
            }
            Sentinel other = (Sentinel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$masterInstance = this.getMasterInstance();
            String other$masterInstance = other.getMasterInstance();
            if (this$masterInstance == null ? other$masterInstance != null : !this$masterInstance.equals(other$masterInstance)) {
                return false;
            }
            List<SentinelNode> this$nodes = this.getNodes();
            List<SentinelNode> other$nodes = other.getNodes();
            return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Sentinel;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $masterInstance = this.getMasterInstance();
            result = result * 59 + ($masterInstance == null ? 43 : $masterInstance.hashCode());
            List<SentinelNode> $nodes = this.getNodes();
            result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RedisConfig.Sentinel(enabled=" + this.isEnabled() + ", masterInstance=" + this.getMasterInstance() + ", nodes=" + this.getNodes() + ")";
        }

        public static class SentinelNode {
            private String host;
            private Integer port;
            private char[] password;

            public SentinelNode(String nodeUri) {
                NodeUriCredentials credentials = RedisConfig.parseCredentialsFromUri(nodeUri);
                this.password = credentials.getPassword();
                this.host = RedisConfig.parseHostFromUri(nodeUri);
                this.port = RedisConfig.parsePortFromUri(nodeUri);
            }

            @Generated
            public String getHost() {
                return this.host;
            }

            @Generated
            public Integer getPort() {
                return this.port;
            }

            @Generated
            public char[] getPassword() {
                return this.password;
            }

            @Generated
            public void setHost(String host) {
                this.host = host;
            }

            @Generated
            public void setPort(Integer port) {
                this.port = port;
            }

            @Generated
            public void setPassword(char[] password) {
                this.password = password;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SentinelNode)) {
                    return false;
                }
                SentinelNode other = (SentinelNode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$port = this.getPort();
                Integer other$port = other.getPort();
                if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                    return false;
                }
                String this$host = this.getHost();
                String other$host = other.getHost();
                if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                    return false;
                }
                return Arrays.equals(this.getPassword(), other.getPassword());
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SentinelNode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $port = this.getPort();
                result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
                String $host = this.getHost();
                result = result * 59 + ($host == null ? 43 : $host.hashCode());
                result = result * 59 + Arrays.hashCode(this.getPassword());
                return result;
            }

            @Generated
            public String toString() {
                return "RedisConfig.Sentinel.SentinelNode(host=" + this.getHost() + ", port=" + this.getPort() + ", password=" + Arrays.toString(this.getPassword()) + ")";
            }
        }
    }
}

