/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching;

import javax.annotation.Nonnull;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.context.ApplicationListener;
import org.springframework.retry.annotation.EnableRetry;
import org.zowe.apiml.enable.EnableApiDiscovery;
import org.zowe.apiml.product.logging.annotations.EnableApimlLogger;
import org.zowe.apiml.product.service.ServiceStartupEventHandler;

@SpringBootApplication
@EnableCircuitBreaker
@EnableApiDiscovery
@EnableRetry
@EnableApimlLogger
public class CachingService
implements ApplicationListener<ApplicationReadyEvent> {
    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{CachingService.class});
        app.setLogStartupInfo(false);
        app.run(args);
    }

    public void onApplicationEvent(@Nonnull ApplicationReadyEvent event) {
        new ServiceStartupEventHandler().onServiceStartup("Caching Service", 5);
    }
}

