/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.commons.zos;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.zowe.commons.attls.AttlsContext;

public class AttlsNativeLibraries {
    public List<String> getNativeLibrariesNames() {
        ArrayList<String> libraries = new ArrayList<String>();
        libraries.add("zowe-attls");
        return libraries;
    }

    public static void extractLib(String directory, String fileName) throws IOException {
        File library = new File(directory, fileName);
        try (InputStream inputStream = AttlsContext.class.getResourceAsStream("/lib/" + fileName);){
            Files.copy(inputStream, library.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            library.delete();
            throw e;
        }
        catch (NullPointerException e) {
            library.delete();
            throw new FileNotFoundException(fileName + " does not exist in JAR.");
        }
    }

    public static void main(String[] args) throws IOException {
        AttlsNativeLibraries.extractLib(args[0], args[1]);
    }
}

