/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.enable.register;

import com.ca.mfaas.eurekaservice.client.ApiMediationClient;
import com.ca.mfaas.eurekaservice.client.config.ApiMediationServiceConfig;
import com.ca.mfaas.exception.ServiceDefinitionException;
import com.ca.mfaas.message.log.ApimlLogger;
import com.ca.mfaas.product.logging.annotations.InjectApimlLogger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class RegisterToApiLayer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegisterToApiLayer.class);
    private final ApiMediationClient apiMediationClient;
    private final ApiMediationServiceConfig newConfig;
    private ApiMediationServiceConfig config;
    @Value(value="${apiml.enabled:true}")
    private boolean apimlEnabled;
    @InjectApimlLogger
    private final ApimlLogger logger = ApimlLogger.empty();

    @EventListener(value={ContextRefreshedEvent.class})
    public void onContextRefreshedEventEvent() {
        if (this.apimlEnabled) {
            if (this.apiMediationClient.getEurekaClient() != null) {
                if (this.config != null) {
                    this.logger.log("apiml.enabler.registration.renew", new Object[]{this.config.getBaseUrl(), this.config.getServiceIpAddress(), this.config.getDiscoveryServiceUrls(), this.newConfig.getBaseUrl(), this.newConfig.getServiceIpAddress(), this.newConfig.getDiscoveryServiceUrls()});
                }
                this.unregister();
            } else {
                this.logger.log("apiml.enabler.registration.initial", new Object[]{this.newConfig.getBaseUrl(), this.newConfig.getServiceIpAddress(), this.newConfig.getDiscoveryServiceUrls()});
            }
            this.register(this.newConfig);
        }
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onContextClosedEvent() {
        if (this.apiMediationClient.getEurekaClient() != null) {
            this.unregister();
        }
    }

    private void unregister() {
        this.apiMediationClient.unregister();
    }

    private void register(ApiMediationServiceConfig newConfig) {
        this.config = newConfig;
        try {
            this.apiMediationClient.register(this.config);
            this.logger.log("apiml.enabler.registration.successful", new Object[]{this.config.getBaseUrl(), this.config.getServiceIpAddress(), this.config.getDiscoveryServiceUrls()});
            log.debug("Registering to API Mediation Layer with settings: {}", (Object)this.config.toString());
        }
        catch (ServiceDefinitionException e) {
            this.logger.log("apiml.enabler.registration.fail", new Object[]{this.config.getBaseUrl(), this.config.getServiceIpAddress(), this.config.getDiscoveryServiceUrls(), e.toString()});
            log.debug(String.format("Service %s registration to API ML failed: ", this.config.getBaseUrl()), (Throwable)e);
        }
    }

    @Generated
    public RegisterToApiLayer(ApiMediationClient apiMediationClient, ApiMediationServiceConfig newConfig) {
        this.apiMediationClient = apiMediationClient;
        this.newConfig = newConfig;
    }
}

