/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.enable.config;

import com.ca.mfaas.eurekaservice.client.ApiMediationClient;
import com.ca.mfaas.eurekaservice.client.config.ApiMediationServiceConfig;
import com.ca.mfaas.eurekaservice.client.impl.ApiMediationClientImpl;
import com.ca.mfaas.message.core.MessageService;
import com.ca.mfaas.message.yaml.YamlMessageService;
import com.ca.mfaas.message.yaml.YamlMessageServiceInstance;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"com.ca.apiml.enable"})
public class EnableApiDiscoveryConfig {
    @Value(value="${apiml.enabled:false}")
    private boolean enabled;

    @Bean
    public MessageService messageServiceDiscovery() {
        YamlMessageService messageService = YamlMessageServiceInstance.getInstance();
        messageService.loadMessages("/onboarding-enabler-spring-messages.yml");
        return messageService;
    }

    @Bean
    public ApiMediationClient apiMediationClient() {
        return new ApiMediationClientImpl();
    }

    @ConfigurationProperties(prefix="apiml.service")
    @Bean
    public ApiMediationServiceConfig apiMediationServiceConfig() {
        return new ApiMediationServiceConfig();
    }

    @Bean
    public Boolean apimlEnabled() {
        return this.enabled;
    }
}

