/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.enable;

import com.ca.mfaas.enable.conditions.ConditionalOnMissingProperty;
import com.ca.mfaas.enable.model.ApiDocConfigException;
import com.ca.mfaas.enable.model.ApiPropertiesContainer;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@ConditionalOnProperty(prefix="eureka.instance.metadata-map.mfaas.discovery", value={"enableApiDoc"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingProperty(value={"eureka.instance.metadata-map.mfaas.api-info.swagger.location"})
@Configuration
@EnableSwagger2
public class EnablerV2SpringFoxConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnablerV2SpringFoxConfig.class);

    @Autowired
    public EnablerV2SpringFoxConfig(ApiPropertiesContainer apiPropertiesContainer, DefaultListableBeanFactory beanFactory) {
        apiPropertiesContainer.getApiVersionProperties().forEach((apiVersion, apiInfo) -> {
            Docket apiDocketBean;
            try {
                apiDocketBean = this.generateDocket((String)apiVersion, (ApiPropertiesContainer.ApiProperties)apiInfo);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return;
            }
            String beanName = apiVersion.trim() + "_API";
            beanFactory.initializeBean((Object)apiDocketBean, beanName);
            beanFactory.autowireBeanProperties((Object)apiDocketBean, 2, true);
            beanFactory.registerSingleton(beanName, (Object)apiDocketBean);
            log.info("Generated bean: " + beanName + " for API version: " + apiVersion.trim());
        });
    }

    private Docket generateDocket(String apiVersion, ApiPropertiesContainer.ApiProperties apiInfo) {
        String groupName = apiVersion;
        if (apiInfo.getGroupName() != null && !apiInfo.getGroupName().isEmpty()) {
            groupName = apiInfo.getGroupName();
        }
        if (apiInfo.getBasePackage() == null && apiInfo.getApiPattern() == null) {
            return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.any()).build().apiInfo(new ApiInfo(apiInfo.getTitle(), apiInfo.getDescription(), apiInfo.getVersion(), null, null, null, null, Collections.emptyList())).groupName(groupName);
        }
        if (apiInfo.getBasePackage() != null && !apiInfo.getBasePackage().isEmpty()) {
            return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.basePackage((String)apiInfo.getBasePackage())).build().apiInfo(new ApiInfo(apiInfo.getTitle(), apiInfo.getDescription(), apiInfo.getVersion(), null, null, null, null, Collections.emptyList())).groupName(groupName);
        }
        if (apiInfo.getApiPattern() != null && !apiInfo.getApiPattern().isEmpty()) {
            return new Docket(DocumentationType.SWAGGER_2).select().paths(PathSelectors.regex((String)apiInfo.getApiPattern())).build().apiInfo(new ApiInfo(apiInfo.getTitle(), apiInfo.getDescription(), apiInfo.getVersion(), null, null, null, null, Collections.emptyList())).groupName(groupName);
        }
        String msg = "A base package or API pattern was not found for version: " + apiVersion;
        ApiDocConfigException t = new ApiDocConfigException(msg);
        log.error(msg, (Throwable)t);
        throw t;
    }
}

