/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.enable.api;

import com.ca.mfaas.enable.services.LocalApiDocService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.swagger.web.InMemorySwaggerResourcesProvider;

@RestController
@RequestMapping(value={"/"})
public class ApiDocController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDocController.class);
    private final boolean apiDocEnabled;
    private LocalApiDocService localApiDocService;
    private InMemorySwaggerResourcesProvider swaggerResourcesProvider;
    private String swaggerLocation;

    @Autowired
    public ApiDocController(@Value(value="${eureka.instance.metadata-map.mfaas.discovery.enableApiDoc:true}") boolean apiDocEnabled, @Value(value="${eureka.instance.metadata-map.mfaas.api-info.swagger.location:}") String swaggerLocation, @Autowired(required=false) LocalApiDocService localApiDocService) {
        this.apiDocEnabled = apiDocEnabled;
        this.localApiDocService = localApiDocService;
        this.swaggerLocation = swaggerLocation;
    }

    @GetMapping(value={"/api-doc"}, produces={"application/json;charset=UTF-8"})
    public String getApiDoc(@RequestParam(value="group", required=false) String apiDocGroup) throws IOException {
        if (this.swaggerLocation == null || this.swaggerLocation.isEmpty()) {
            return this.localApiDocService.getApiDoc(apiDocGroup);
        }
        return this.loadApiDocumentationFromStaticResourceFileAsJson();
    }

    @GetMapping(value={"/api-doc/enabled"}, produces={"application/json;charset=UTF-8"})
    public boolean isApiDocEnabled() {
        return this.apiDocEnabled;
    }

    private String loadApiDocumentationFromStaticResourceFileAsJson() throws IOException {
        log.debug("Loading Api Documentation from static resource: " + this.swaggerLocation);
        try {
            File file;
            if (!this.swaggerLocation.startsWith("classpath:")) {
                this.swaggerLocation = "classpath:" + this.swaggerLocation.trim();
            }
            if (!(file = ResourceUtils.getFile((String)this.swaggerLocation)).exists()) {
                throw new IOException("Cannot find Api Documentation (swagger) file: " + this.swaggerLocation);
            }
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            log.error("An exception occurred when attempting to retrieve swagger file: " + this.swaggerLocation + ". " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Generated
    public LocalApiDocService getLocalApiDocService() {
        return this.localApiDocService;
    }

    @Generated
    public InMemorySwaggerResourcesProvider getSwaggerResourcesProvider() {
        return this.swaggerResourcesProvider;
    }

    @Generated
    public String getSwaggerLocation() {
        return this.swaggerLocation;
    }

    @Generated
    public void setLocalApiDocService(LocalApiDocService localApiDocService) {
        this.localApiDocService = localApiDocService;
    }

    @Generated
    public void setSwaggerResourcesProvider(InMemorySwaggerResourcesProvider swaggerResourcesProvider) {
        this.swaggerResourcesProvider = swaggerResourcesProvider;
    }

    @Generated
    public void setSwaggerLocation(String swaggerLocation) {
        this.swaggerLocation = swaggerLocation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiDocController)) {
            return false;
        }
        ApiDocController other = (ApiDocController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isApiDocEnabled() != other.isApiDocEnabled()) {
            return false;
        }
        LocalApiDocService this$localApiDocService = this.getLocalApiDocService();
        LocalApiDocService other$localApiDocService = other.getLocalApiDocService();
        if (this$localApiDocService == null ? other$localApiDocService != null : !this$localApiDocService.equals(other$localApiDocService)) {
            return false;
        }
        InMemorySwaggerResourcesProvider this$swaggerResourcesProvider = this.getSwaggerResourcesProvider();
        InMemorySwaggerResourcesProvider other$swaggerResourcesProvider = other.getSwaggerResourcesProvider();
        if (this$swaggerResourcesProvider == null ? other$swaggerResourcesProvider != null : !this$swaggerResourcesProvider.equals(other$swaggerResourcesProvider)) {
            return false;
        }
        String this$swaggerLocation = this.getSwaggerLocation();
        String other$swaggerLocation = other.getSwaggerLocation();
        return !(this$swaggerLocation == null ? other$swaggerLocation != null : !this$swaggerLocation.equals(other$swaggerLocation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiDocController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isApiDocEnabled() ? 79 : 97);
        LocalApiDocService $localApiDocService = this.getLocalApiDocService();
        result = result * 59 + ($localApiDocService == null ? 43 : $localApiDocService.hashCode());
        InMemorySwaggerResourcesProvider $swaggerResourcesProvider = this.getSwaggerResourcesProvider();
        result = result * 59 + ($swaggerResourcesProvider == null ? 43 : $swaggerResourcesProvider.hashCode());
        String $swaggerLocation = this.getSwaggerLocation();
        result = result * 59 + ($swaggerLocation == null ? 43 : $swaggerLocation.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiDocController(apiDocEnabled=" + this.isApiDocEnabled() + ", localApiDocService=" + this.getLocalApiDocService() + ", swaggerResourcesProvider=" + this.getSwaggerResourcesProvider() + ", swaggerLocation=" + this.getSwaggerLocation() + ")";
    }
}

