/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class StringUtils {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");

    public static String removeFirstAndLastOccurrence(String input, String str) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).isEmpty()) {
            return "";
        }
        int start = 0;
        int stop = input.length();
        if (input.startsWith(str)) {
            start = 1;
        }
        if (input.endsWith(str)) {
            stop = input.length() - 1;
        }
        input = input.substring(start, stop);
        return input;
    }

    public static String prependSubstring(String uri, String subStr) {
        return StringUtils.prependSubstring(uri, subStr, true);
    }

    public static String prependSubstring(String uri, String subStr, boolean checkAlreadyPrepended) {
        return StringUtils.prependSubstring(uri, subStr, checkAlreadyPrepended, true);
    }

    public static String prependSubstring(String uri, String subStr, boolean checkAlreadyPrepended, boolean shouldTrimWhitespaceFirst) {
        if (uri == null) {
            return null;
        }
        if (subStr == null) {
            return null;
        }
        if (shouldTrimWhitespaceFirst) {
            uri = uri.trim();
        }
        if (!checkAlreadyPrepended || !uri.startsWith(subStr)) {
            uri = subStr + uri;
        }
        return uri;
    }

    public static String removeLastOccurrence(String input, String subStr) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).isEmpty()) {
            return "";
        }
        if (input.endsWith(subStr)) {
            input = input.substring(0, input.length() - 1);
        }
        return input;
    }

    public static String resolveExpressions(String expression, Map<String, String> properties) {
        if (expression == null || properties == null) {
            return expression;
        }
        StringBuilder result = new StringBuilder(expression.length());
        int i = 0;
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        while (matcher.find()) {
            result.append(expression, i, matcher.start());
            String property = matcher.group();
            property = property.substring(2, property.length() - 1);
            property = properties.containsKey(property) ? properties.get(property) : matcher.group();
            result.append(property);
            i = matcher.end();
        }
        result.append(expression.substring(i));
        return result.toString();
    }

    @Generated
    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

