/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectUtil.class);

    public static void requireNotNull(Object param, String message) {
        if (param == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Class getThisClass() {
        Thread theThread = Thread.currentThread();
        StackTraceElement[] stackTrace = theThread.getStackTrace();
        String theClassName = stackTrace[2].getClassName();
        Class<?> theClass = null;
        try {
            theClass = Class.forName(theClassName);
        }
        catch (ClassNotFoundException cnfe) {
            log.warn(String.format("Class %s was not found: ", theClassName), (Throwable)cnfe);
        }
        return theClass;
    }

    public static Map<String, String> getThreadContextMap(ThreadLocal<Map<String, String>> threadConfigurationContext) {
        Map<String, String> aMap = threadConfigurationContext.get();
        if (aMap == null) {
            aMap = new HashMap<String, String>();
            threadConfigurationContext.set(aMap);
        }
        return aMap;
    }

    public static Map<String, Object> mergeConfigurations(Map<String, Object> firstMap, Map<String, Object> secondMap) {
        if (firstMap != null && secondMap != null) {
            return ObjectUtil.mergeMapsDeep(firstMap, secondMap);
        }
        if (secondMap != null) {
            return secondMap;
        }
        return firstMap;
    }

    private static Map<String, Object> mergeMapsDeep(Map map1, Map map2) {
        for (Map.Entry entry : map2.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (map1.get(key) instanceof Map && value instanceof Map) {
                map1.put(key, ObjectUtil.mergeMapsDeep((Map)map1.get(key), (Map)value));
                continue;
            }
            if (map1.get(key) instanceof List && value instanceof List) {
                Collection originalChild = (Collection)map1.get(key);
                for (Object each : (Collection)value) {
                    if (originalChild.contains(each)) continue;
                    originalChild.add(each);
                }
                continue;
            }
            map1.put(key, value);
        }
        return map1;
    }

    @Generated
    private ObjectUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

