/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static File locateFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        File aFile = FileUtils.locateFileOrDirectory(fileName);
        if (aFile != null && aFile.isFile()) {
            return aFile;
        }
        return null;
    }

    public static File locateDirectory(String directoryName) {
        if (directoryName == null) {
            return null;
        }
        File aFile = FileUtils.locateFileOrDirectory(directoryName);
        if (aFile != null && aFile.isDirectory()) {
            return aFile;
        }
        return null;
    }

    private static File locateFileOrDirectory(String fileName) {
        URL fileUrl = FileUtils.getResourceUrl(fileName);
        if (fileUrl != null) {
            return new File(fileUrl.getFile());
        }
        File file = null;
        Path path = Paths.get(fileName, new String[0]);
        if (path != null) {
            if (path.isAbsolute()) {
                return path.toFile();
            }
            file = Paths.get(System.getProperty("user.dir"), new String[0]).resolve(path).toFile();
            if (file != null && file.canRead()) {
                return file;
            }
            file = Paths.get(System.getProperty("user.home"), new String[0]).resolve(path).toFile();
            if (file != null && file.canRead()) {
                return file;
            }
        }
        return file;
    }

    private static URL getResourceUrl(String fileName) {
        URL fileUrl = FileUtils.class.getResource(fileName);
        if (fileUrl == null) {
            log.debug(String.format("File resource [%s] can't be found by this class classloader. We'll try with SystemClassLoader...", fileName));
            fileUrl = ClassLoader.getSystemResource(fileName);
            if (fileUrl == null) {
                log.debug(String.format("File resource [%s] can't be found by SystemClassLoader.", fileName));
            }
        }
        return fileUrl;
    }

    public static String readConfigurationFile(String fileName) throws IOException {
        String fileData = null;
        File file = FileUtils.locateFile(fileName);
        if (file != null) {
            fileData = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
        }
        return fileData;
    }
}

