/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.message.log;

import com.ca.mfaas.message.core.Message;
import com.ca.mfaas.message.core.MessageService;
import com.ca.mfaas.message.core.MessageType;
import com.ca.mfaas.util.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class ApimlLogger {
    private final MessageService messageService;
    private final Logger logger;
    private static final Marker marker = MarkerFactory.getMarker((String)"APIML-LOGGER");

    public ApimlLogger(Class<?> clazz, MessageService messageService) {
        this.messageService = messageService;
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public static ApimlLogger of(Class<?> clazz, MessageService messageService) {
        return new ApimlLogger(clazz, messageService);
    }

    public static ApimlLogger empty() {
        return new ApimlLogger(ApimlLogger.class, null);
    }

    public void log(String key, Object ... parameters) {
        ObjectUtil.requireNotNull(key, "key can't be null");
        ObjectUtil.requireNotNull(parameters, "parameters can't be null");
        if (this.messageService != null) {
            Message message = this.messageService.createMessage(key, parameters);
            this.log(message);
        }
    }

    public void log(Message message) {
        ObjectUtil.requireNotNull(message, "message can't be null");
        ObjectUtil.requireNotNull(message.getMessageTemplate(), "message template can't be null");
        this.log(message.getMessageTemplate().getType(), message.mapToLogMessage(), new Object[0]);
    }

    public void log(MessageType messageType, String text, Object ... arguments) {
        ObjectUtil.requireNotNull((Object)messageType, "messageType can't be null");
        ObjectUtil.requireNotNull(text, "text can't be null");
        ObjectUtil.requireNotNull(arguments, "arguments can't be null");
        switch (messageType) {
            case TRACE: {
                this.logger.trace(marker, text, arguments);
                break;
            }
            case DEBUG: {
                this.logger.debug(marker, text, arguments);
                break;
            }
            case INFO: {
                this.logger.info(marker, text, arguments);
                break;
            }
            case WARNING: {
                this.logger.warn(marker, text, arguments);
                break;
            }
            case ERROR: {
                this.logger.error(marker, text, arguments);
                break;
            }
            default: {
                this.logger.warn(marker, "The following message contains invalid message type.");
                this.logger.info(marker, text, arguments);
            }
        }
    }
}

