/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.routing.transform;

import com.ca.mfaas.message.log.ApimlLogger;
import com.ca.mfaas.product.gateway.GatewayClient;
import com.ca.mfaas.product.gateway.GatewayConfigProperties;
import com.ca.mfaas.product.logging.annotations.InjectApimlLogger;
import com.ca.mfaas.product.routing.RoutedService;
import com.ca.mfaas.product.routing.RoutedServices;
import com.ca.mfaas.product.routing.ServiceType;
import com.ca.mfaas.product.routing.transform.URLTransformationException;
import com.ca.mfaas.util.UrlUtils;
import java.net.URI;
import lombok.Generated;

public class TransformService {
    private static final String SEPARATOR = "/";
    private final GatewayClient gatewayClient;
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();

    public String transformURL(ServiceType type, String serviceId, String serviceUrl, RoutedServices routes) throws URLTransformationException {
        String endPoint;
        if (!this.gatewayClient.isInitialized()) {
            this.apimlLog.log("apiml.common.gatewayNotFoundForTransformRequest", new Object[0]);
            throw new URLTransformationException("Gateway not found yet, transform service cannot perform the request");
        }
        URI serviceUri = URI.create(serviceUrl);
        String serviceUriPath = serviceUri.getPath();
        if (serviceUriPath == null) {
            String message = String.format("The URI %s is not valid.", serviceUri);
            throw new URLTransformationException(message);
        }
        RoutedService route = routes.getBestMatchingServiceUrl(serviceUriPath, type);
        if (route == null) {
            String message = String.format("Not able to select route for url %s of the service %s. Original url used.", serviceUri, serviceId);
            throw new URLTransformationException(message);
        }
        if (serviceUri.getQuery() != null) {
            serviceUriPath = serviceUriPath + "?" + serviceUri.getQuery();
        }
        if (!(endPoint = this.getShortEndPoint(route.getServiceUrl(), serviceUriPath)).isEmpty() && !endPoint.startsWith(SEPARATOR)) {
            throw new URLTransformationException("The path " + serviceUri.getPath() + " of the service URL " + serviceUri + " is not valid.");
        }
        GatewayConfigProperties gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        return String.format("%s://%s/%s/%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), route.getGatewayUrl(), serviceId, endPoint);
    }

    private String getShortEndPoint(String routeServiceUrl, String endPoint) {
        String shortEndPoint = endPoint;
        if (!routeServiceUrl.equals(SEPARATOR)) {
            shortEndPoint = shortEndPoint.replaceFirst(UrlUtils.removeLastSlash((String)routeServiceUrl), "");
        }
        return shortEndPoint;
    }

    @Generated
    public TransformService(GatewayClient gatewayClient) {
        this.gatewayClient = gatewayClient;
    }
}

