/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import java.util.Arrays;
import java.util.Collections;
import javax.servlet.Filter;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.zowe.apiml.discovery.config.AbstractWebSecurityConfigurer;
import org.zowe.apiml.security.common.config.HandlerInitializer;
import org.zowe.apiml.security.common.content.BasicContentFilter;

@Configuration
@ComponentScan(value={"org.zowe.apiml.security.common"})
@EnableWebSecurity
@Profile(value={"!https", "!attls"})
public class HttpWebSecurityConfig
extends AbstractWebSecurityConfigurer {
    private static final String DISCOVERY_REALM = "API Mediation Discovery Service realm";
    @Value(value="${apiml.discovery.userid:eureka}")
    private String eurekaUserid;
    @Value(value="${apiml.discovery.password:password}")
    private char[] eurekaPassword;
    @Value(value="${apiml.metrics.enabled:false}")
    private boolean isMetricsEnabled;
    private final HandlerInitializer handlerInitializer;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider(new AuthenticationProvider(){
            private final MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (StringUtils.equals((CharSequence)HttpWebSecurityConfig.this.eurekaUserid, (CharSequence)String.valueOf(authentication.getPrincipal())) && authentication.getCredentials() != null) {
                    char[] credentials = authentication.getCredentials() instanceof char[] ? (char[])authentication.getCredentials() : String.valueOf(authentication.getCredentials()).toCharArray();
                    if (Arrays.equals(HttpWebSecurityConfig.this.eurekaPassword, credentials)) {
                        UsernamePasswordAuthenticationToken result = UsernamePasswordAuthenticationToken.authenticated((Object)authentication.getPrincipal(), (Object)authentication.getCredentials(), Collections.singleton(new SimpleGrantedAuthority("EUREKA")));
                        result.setDetails(authentication.getDetails());
                        return result;
                    }
                }
                throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
            }

            public boolean supports(Class<?> authentication) {
                return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
            }
        });
    }

    public void configure(WebSecurity web) {
        String[] noSecurityAntMatchers = new String[]{"/favicon.ico", "/eureka/css/**", "/eureka/js/**", "/eureka/fonts/**", "/eureka/images/**"};
        web.ignoring().antMatchers(noSecurityAntMatchers);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)this.baseConfigure(http).addFilterBefore((Filter)this.basicFilter(this.authenticationManager()), UsernamePasswordAuthenticationFilter.class).httpBasic().realmName(DISCOVERY_REALM).and()).authorizeRequests().antMatchers(new String[]{"/application/info", "/application/health"})).permitAll().antMatchers(new String[]{"/**"})).authenticated();
        if (this.isMetricsEnabled) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/application/hystrix.stream"})).permitAll();
        }
    }

    private BasicContentFilter basicFilter(AuthenticationManager authenticationManager) {
        return new BasicContentFilter(authenticationManager, (AuthenticationFailureHandler)this.handlerInitializer.getAuthenticationFailureHandler(), this.handlerInitializer.getResourceAccessExceptionHandler());
    }

    @Generated
    public HttpWebSecurityConfig(HandlerInitializer handlerInitializer) {
        this.handlerInitializer = handlerInitializer;
    }
}

