package com.yaantra.neeraj.serviceslib;

import android.Manifest;
import android.app.Dialog;
import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.os.Vibrator;
import android.util.SparseArray;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;

import androidx.core.app.ActivityCompat;

import com.google.android.gms.vision.CameraSource;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;

public class CodeScanner {


    public static void Scan(final Context context, final InstantData<String> instantData) {
        final String[] data = {""};
        final boolean[] hasBackCamera = {false};
        final Dialog dialog;

        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int numberOfCameras = Camera.getNumberOfCameras();
        for (int i = 0; i < numberOfCameras; i++) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing == Camera.CameraInfo.CAMERA_FACING_FRONT) {
                hasBackCamera[0] = true;
            }
        }

        if (hasBackCamera[0] == false) {
            instantData.getResponseError("No Back Camera to Scan");

        } else {
            final SurfaceView cameraView;
            BarcodeDetector barcodeDetector;
            final CameraSource cameraSource;

            dialog = new Dialog(context, android.R.style.Theme_Translucent_NoTitleBar);
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            dialog.setContentView(R.layout.scan_code_layout);

            cameraView = dialog.findViewById(R.id.surface_view);
            final View bar = dialog.findViewById(R.id.bar);
            final Animation animation = AnimationUtils.loadAnimation(context, R.anim.slider_anim);

            barcodeDetector = new BarcodeDetector.Builder(context).setBarcodeFormats(Barcode.ALL_FORMATS).build();
            cameraSource = new CameraSource.Builder(context, barcodeDetector)
                    .setFacing(CameraSource.CAMERA_FACING_BACK)
                    .setRequestedPreviewSize(640, 480)
                    .setAutoFocusEnabled(true).build();

            cameraView.getHolder().addCallback(new SurfaceHolder.Callback() {
                @Override
                public void surfaceCreated(SurfaceHolder surfaceHolder) {
                    try {
                        if (ActivityCompat.checkSelfPermission(context, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                            instantData.getResponseError("Allow Camera Permission");
                            return;
                        }
                        cameraSource.start(cameraView.getHolder());
                        bar.startAnimation(animation);

                    } catch (Exception ie) {
                        AppUtils.LogE("CAMERA SOURCE:"+ ie.getMessage());
                        instantData.getResponseError(ie.getMessage().toString());
                    }
                }

                @Override
                public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {}

                @Override
                public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                    cameraSource.stop();
                }
            });

            barcodeDetector.setProcessor(new Detector.Processor<Barcode>() {
                @Override
                public void release() {}

                @Override
                public void receiveDetections(Detector.Detections<Barcode> detections) {
                    final SparseArray<Barcode> barcodes = detections.getDetectedItems();
                    if (barcodes.size() != 0) {
                        final Vibrator vb = (Vibrator) context.getSystemService(Context.VIBRATOR_SERVICE);

                        cameraView.post(new Runnable() {
                            public void run() {

                                try {
                                    data[0] = barcodes.valueAt(0).displayValue;
                                    AppUtils.LogD("barcode:" + data[0]);
                                    vb.vibrate(100);
                                    cameraSource.stop();
                                    instantData.getResponse(data[0]);

                                } catch (Exception e) {
                                    e.printStackTrace();
                                    instantData.getResponseError(e.getMessage().toString());
                                }
                                dialog.dismiss();
                            }
                        });
                    }
                }
            });
            dialog.show();
        }
    }
}
