package com.yaantra.neeraj.serviceslib;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class ServicePost {

    public static Context context;
    public static int connection_time_out = 240000;

    public static ServicePost instance;

    public ServicePost(Context context) {
        this.context = context;
    }

    public static synchronized ServicePost getInstance (Context context){
        if(null == instance){
            instance = new ServicePost(context);
        }
        return instance;
    }

    public class PostClass extends AsyncTask<String, Void, String> {

        public InstantData<String> instantDatas;
        public String urll = "";
        public String urlParameters = "";

        public PostClass(String url, String urlParameters, final InstantData<String> instantData){
            this.instantDatas =  instantData;
            this.urll =  url;
            this.urlParameters = urlParameters;
        }

        @Override
        protected String doInBackground(String... params) {
            try {
                System.out.println("\nPOST URL: " + urll);
                System.out.println("POST PARAMETER: " + urlParameters);

                URL url = new URL(urll);

                if (context.getResources().getString(R.string.Content_Type).isEmpty() || context.getResources().getString(R.string.Authorization).isEmpty())
                    Log.e("Library TAG","Please set Url Header in strings.xml class, named as: Content_Type & Authorization");

                HttpURLConnection connection = (HttpURLConnection) url.openConnection();
                connection.setRequestProperty("Content-Type", context.getResources().getString(R.string.Content_Type));
                connection.setRequestProperty("Authorization", context.getResources().getString(R.string.Authorization));

                connection.setRequestMethod("POST");
                DataOutputStream dStream = new DataOutputStream(connection.getOutputStream());
                dStream.writeBytes(urlParameters);
                dStream.flush();
                dStream.close();
                int responseCode = connection.getResponseCode();

                if (responseCode == 404){
                    instantDatas.getResponseError("Error:404");
                }
                if (responseCode == 500){
                    instantDatas.getResponseError("Error:500");
                }
                final StringBuilder output = new StringBuilder("Request URL " + url);
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = "";
                final StringBuilder responseOutput = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    responseOutput.append(line);
                }
                br.close();

                output.append(System.getProperty("line.separator") + "Response " + System.getProperty("line.separator") + System.getProperty("line.separator") + responseOutput.toString());
                return responseOutput.toString();

            } catch (MalformedURLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                instantDatas.getResponseError("Error: "+e.getMessage());
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                instantDatas.getResponseError("Error: "+e.getMessage());
            }
            return null;
        }

        @Override
        protected void onPostExecute(String result) {
            super.onPostExecute(result);
            System.out.println("Return Response = "+ result);
            if (result== null){
                instantDatas.getResponse("error");
            } else {
                instantDatas.getResponse(result);
            }
        }
    }

    public void GetApi(final String url , final InstantData<String> instantData){
        System.out.println("\nGET URL: " + url);

        RequestQueue queue = Volley.newRequestQueue(context);
        StringRequest stringRequest = new StringRequest(Request.Method.GET, url,
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String response) {
                        instantData.getResponse(response);
                        System.out.println("Response: " + response);
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                instantData.getResponseError("Error");
                System.out.println("Error: " + error.getMessage());
            }
        });
        stringRequest.setRetryPolicy(new DefaultRetryPolicy(connection_time_out,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        queue.add(stringRequest);
    }

    public void GetAddress(final InstantData<String> instantData) {

        GPSTracker gps = new GPSTracker(context);
        if (gps.canGetLocation()) {
            double latitude = gps.getLatitude();
            double longitude = gps.getLongitude();

            if (context.getResources().getString(R.string.Address_API_Key).isEmpty())
                Log.e("Library TAG", "Set Google Address API Key in strings.xml class, named as: Address_API_Key");

            String url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=" + latitude + "," + longitude + "&key=" + context.getResources().getString(R.string.Address_API_Key);
            System.out.println("GET URL: " + url);

            RequestQueue queue = Volley.newRequestQueue(context);
            StringRequest stringRequest = new StringRequest(Request.Method.GET, url,
                    new Response.Listener<String>() {
                        @Override
                        public void onResponse(String response) {

                            JSONObject jsonObj = new JSONObject();
                            String formatted_address = "";
                            String administrative_area_level_1 = "";
                            String administrative_area_level_2 = "";
                            String locality = "";
                            String political = "";
                            String country = "";
                            String postal_code = "";
                            try {
                                JSONObject jsonObject = new JSONObject(response);
                                String status = jsonObject.isNull("status") ? "" : jsonObject.getString("status");

                                if (status.equalsIgnoreCase("OK")) {
                                    JSONArray jsonArray = jsonObject.getJSONArray("results");

                                    JSONObject object = jsonArray.getJSONObject(0);
                                    formatted_address = object.isNull("formatted_address") ? "" : object.getString("formatted_address");

                                    for (int i = 0; i < jsonArray.length(); i++) {
                                        JSONObject object2 = jsonArray.getJSONObject(i);
                                        JSONArray jsonArray2 = object2.getJSONArray("address_components");

                                        for (int j = 0; j < jsonArray2.length(); j++) {
                                            JSONObject object3 = jsonArray2.getJSONObject(j);
                                            JSONArray jsonArray3 = object3.getJSONArray("types");
                                            String addStr = jsonArray3.getString(0);

                                            if (addStr.equalsIgnoreCase("administrative_area_level_1") && administrative_area_level_1.equalsIgnoreCase("")) {
                                                administrative_area_level_1 = object3.isNull("long_name") ? "" : object3.getString("long_name");
                                            }
                                            if (addStr.equalsIgnoreCase("administrative_area_level_2") && administrative_area_level_2.equalsIgnoreCase("")) {
                                                administrative_area_level_2 = object3.isNull("long_name") ? "" : object3.getString("long_name");
                                            }
                                            if (addStr.equalsIgnoreCase("locality") && locality.equalsIgnoreCase("")) {
                                                locality = object3.isNull("long_name") ? "" : object3.getString("long_name");
                                            }
                                            if (addStr.equalsIgnoreCase("political") && political.equalsIgnoreCase("")) {
                                                political = object3.isNull("long_name") ? "" : object3.getString("long_name");
                                            }
                                            if (addStr.equalsIgnoreCase("country") && country.equalsIgnoreCase("")) {
                                                country = object3.isNull("long_name") ? "" : object3.getString("long_name");
                                            }
                                            if (addStr.equalsIgnoreCase("postal_code") && postal_code.equalsIgnoreCase("")) {
                                                postal_code = object3.isNull("long_name") ? "" : object3.getString("long_name");
                                            }
                                        }
                                    }
                                    jsonObj.put("Formatted_Address", formatted_address);
                                    jsonObj.put("Administrative_Area_Level_1", administrative_area_level_1);
                                    jsonObj.put("Administrative_Area_Level_2", administrative_area_level_2);
                                    jsonObj.put("Locality", locality);
                                    jsonObj.put("Political", political);
                                    jsonObj.put("Country", country);
                                    jsonObj.put("Postal_Code", postal_code);

                                    instantData.getResponse(jsonObj.toString());

                                } else {
                                    instantData.getResponse("Error");
                                }

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    instantData.getResponseError("Error");
                    System.out.println("Error: " + error.getMessage());
                }
            });
            stringRequest.setRetryPolicy(new DefaultRetryPolicy(connection_time_out,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES, DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
            queue.add(stringRequest);

        } else {
            gps.showSettingsAlert(new InterFaceClass<String>() {
                @Override
                public void getResponse(String repose) {
                    if (repose.equals("On")) {
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                GetAddress(instantData);
                            }
                        }, 1000);
                    }
                }
            });
        }
    }
}
