package com.yaantra.neeraj.serviceslib;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import java.io.File;

import static android.app.Activity.RESULT_OK;
import static android.widget.ImageView.ScaleType.CENTER_CROP;
import static android.widget.ImageView.ScaleType.CENTER_INSIDE;

public class AppUtils {

    public static void LogD(String value) {
        Log.d("TAG::", value);
    }


    public static void LogE(String value) {
        Log.e("TAG::", value);
    }


    public static void SOP(String value) {
        System.out.println(value);
    }


    public static void Toast(Context context, String msg) {
        Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
    }


    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static void showAlert(Context context, String message) {
        RequestErrorMessage requestErrorMessage = new RequestErrorMessage(context, message);
        requestErrorMessage.setCancelable(false);
        requestErrorMessage.show();
    }

    public static void customToast(Context context, int image, String message, int textColor, int toastBgColor, int gravity) {
        LayoutInflater inflater = ((Activity)context).getLayoutInflater();
        View layout = inflater.inflate(R.layout.custom_layout, (ViewGroup) ((Activity)context).findViewById(R.id.toast_layout_root));

        LinearLayout toastBg = layout.findViewById(R.id.toast_layout_root);
        toastBg.setBackgroundColor(toastBgColor);
        ImageView img = layout.findViewById(R.id.image);
        img.setImageResource(image);
        TextView text = layout.findViewById(R.id.text);
        text.setText(message);
        text.setTextColor(textColor);

        Toast toast = new Toast(context);
        toast.setGravity(gravity, 0, 0);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.setView(layout);
        toast.show();
    }

    public static void blinkView(View view, int duration) {
        Animation animation = new AlphaAnimation(1, 0);
        animation.setDuration(duration);
        animation.setInterpolator(new LinearInterpolator());
        animation.setRepeatCount(Animation.INFINITE);
        animation.setRepeatMode(Animation.REVERSE);
        view.startAnimation(animation);
    }

    public static class CircularImageView extends AppCompatImageView {

        // Default Values
        private final float DEFAULT_BORDER_WIDTH = 4;
        private final float DEFAULT_SHADOW_RADIUS = 8.0f;

        // Properties
        private float borderWidth;
        private int canvasSize;
        private float shadowRadius;
        private int shadowColor = Color.BLACK;
        private ShadowGravity shadowGravity = ShadowGravity.BOTTOM;
        private ColorFilter colorFilter;

        // Object used to draw
        private Bitmap image;
        private Drawable drawable;
        private Paint paint;
        private Paint paintBorder;
        private Paint paintBackground;

        //region Constructor & Init Method
        public CircularImageView(final Context context) {
            this(context, null);
        }

        public CircularImageView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public CircularImageView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
            init(context, attrs, defStyleAttr);
        }

        private void init(Context context, AttributeSet attrs, int defStyleAttr) {
            // Init paint
            paint = new Paint();
            paint.setAntiAlias(true);

            paintBorder = new Paint();
            paintBorder.setAntiAlias(true);

            paintBackground = new Paint();
            paintBackground.setAntiAlias(true);

            // Load the styled attributes and set their properties
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CircularImageView, defStyleAttr, 0);

            // Init Border
            if (attributes.getBoolean(R.styleable.CircularImageView_civ_border, true)) {
                float defaultBorderSize = DEFAULT_BORDER_WIDTH * getContext().getResources().getDisplayMetrics().density;
                setBorderWidth(attributes.getDimension(R.styleable.CircularImageView_civ_border_width, defaultBorderSize));
                setBorderColor(attributes.getColor(R.styleable.CircularImageView_civ_border_color, Color.WHITE));
            }

            setBackgroundColor(attributes.getColor(R.styleable.CircularImageView_civ_background_color, Color.WHITE));

            // Init Shadow
            if (attributes.getBoolean(R.styleable.CircularImageView_civ_shadow, false)) {
                shadowRadius = DEFAULT_SHADOW_RADIUS;
                drawShadow(attributes.getFloat(R.styleable.CircularImageView_civ_shadow_radius, shadowRadius),
                        attributes.getColor(R.styleable.CircularImageView_civ_shadow_color, shadowColor));
                int shadowGravityIntValue = attributes.getInteger(R.styleable.CircularImageView_civ_shadow_gravity, ShadowGravity.BOTTOM.getValue());
                shadowGravity = ShadowGravity.fromValue(shadowGravityIntValue);
            }

            attributes.recycle();
        }
        //endregion

        //region Set Attr Method
        public void setBorderWidth(float borderWidth) {
            this.borderWidth = borderWidth;
            requestLayout();
            invalidate();
        }

        public void setBorderColor(int borderColor) {
            if (paintBorder != null)
                paintBorder.setColor(borderColor);
            invalidate();
        }

        public void setBackgroundColor(int backgroundColor) {
            if (paintBackground != null)
                paintBackground.setColor(backgroundColor);
            invalidate();
        }

        public void addShadow() {
            if (shadowRadius == 0)
                shadowRadius = DEFAULT_SHADOW_RADIUS;
            drawShadow(shadowRadius, shadowColor);
            invalidate();
        }

        public void setShadowRadius(float shadowRadius) {
            drawShadow(shadowRadius, shadowColor);
            invalidate();
        }

        public void setShadowColor(int shadowColor) {
            drawShadow(shadowRadius, shadowColor);
            invalidate();
        }

        public void setShadowGravity(ShadowGravity shadowGravity) {
            this.shadowGravity = shadowGravity;
            invalidate();
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
            if (this.colorFilter == colorFilter)
                return;
            this.colorFilter = colorFilter;
            drawable = null; // To force re-update shader
            invalidate();
        }

        @Override
        public ScaleType getScaleType() {
            ScaleType currentScaleType = super.getScaleType();
            return currentScaleType == null || currentScaleType != CENTER_INSIDE ? CENTER_CROP : currentScaleType;
        }

        @Override
        public void setScaleType(ScaleType scaleType) {
            if (scaleType != CENTER_CROP && scaleType != CENTER_INSIDE) {
                throw new IllegalArgumentException(String.format("ScaleType %s not supported. " +
                        "Just ScaleType.CENTER_CROP & ScaleType.CENTER_INSIDE are available for this library.", scaleType));
            } else {
                super.setScaleType(scaleType);
            }
        }
        //endregion

        //region Draw Method
        @Override
        public void onDraw(Canvas canvas) {
            // Load the bitmap
            loadBitmap();

            // Check if image isn't null
            if (image == null)
                return;

            if (!isInEditMode()) {
                canvasSize = Math.min(canvas.getWidth(), canvas.getHeight());
            }

            // circleCenter is the x or y of the view's center
            // radius is the radius in pixels of the cirle to be drawn
            // paint contains the shader that will texture the shape
            int circleCenter = (int) (canvasSize - (borderWidth * 2)) / 2;
            float margeWithShadowRadius = shadowRadius * 2;

            // Draw Border
            canvas.drawCircle(circleCenter + borderWidth, circleCenter + borderWidth, circleCenter + borderWidth - margeWithShadowRadius, paintBorder);
            // Draw Circle background
            canvas.drawCircle(circleCenter + borderWidth, circleCenter + borderWidth, circleCenter - margeWithShadowRadius, paintBackground);
            // Draw CircularImageView
            canvas.drawCircle(circleCenter + borderWidth, circleCenter + borderWidth, circleCenter - margeWithShadowRadius, paint);
        }

        private void loadBitmap() {
            if (drawable == getDrawable())
                return;

            drawable = getDrawable();
            image = drawableToBitmap(drawable);
            updateShader();
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            canvasSize = Math.min(w, h);
            if (image != null)
                updateShader();
        }

        private void drawShadow(float shadowRadius, int shadowColor) {
            this.shadowRadius = shadowRadius;
            this.shadowColor = shadowColor;
            setLayerType(LAYER_TYPE_SOFTWARE, paintBorder);

            float dx = 0.0f;
            float dy = 0.0f;

            switch (shadowGravity) {
                case CENTER:
                    dx = 0.0f;
                    dy = 0.0f;
                    break;
                case TOP:
                    dx = 0.0f;
                    dy = -shadowRadius / 2;
                    break;
                case BOTTOM:
                    dx = 0.0f;
                    dy = shadowRadius / 2;
                    break;
                case START:
                    dx = -shadowRadius / 2;
                    dy = 0.0f;
                    break;
                case END:
                    dx = shadowRadius / 2;
                    dy = 0.0f;
                    break;
            }

            paintBorder.setShadowLayer(shadowRadius, dx, dy, shadowColor);
        }

        private void updateShader() {
            if (image == null)
                return;

            // Create Shader
            BitmapShader shader = new BitmapShader(image, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);

            // Center Image in Shader
            float scale = 0;
            float dx = 0;
            float dy = 0;

            switch (getScaleType()) {
                case CENTER_CROP:
                    if (image.getWidth() * getHeight() > getWidth() * image.getHeight()) {
                        scale = getHeight() / (float) image.getHeight();
                        dx = (getWidth() - image.getWidth() * scale) * 0.5f;
                    } else {
                        scale = getWidth() / (float) image.getWidth();
                        dy = (getHeight() - image.getHeight() * scale) * 0.5f;
                    }
                    break;
                case CENTER_INSIDE:
                    if (image.getWidth() * getHeight() < getWidth() * image.getHeight()) {
                        scale = getHeight() / (float) image.getHeight();
                        dx = (getWidth() - image.getWidth() * scale) * 0.5f;
                    } else {
                        scale = getWidth() / (float) image.getWidth();
                        dy = (getHeight() - image.getHeight() * scale) * 0.5f;
                    }
                    break;
            }

            Matrix matrix = new Matrix();
            matrix.setScale(scale, scale);
            matrix.postTranslate(dx, dy);
            shader.setLocalMatrix(matrix);

            // Set Shader in Paint
            paint.setShader(shader);

            // Apply colorFilter
            paint.setColorFilter(colorFilter);
        }

        private Bitmap drawableToBitmap(Drawable drawable) {
            if (drawable == null) {
                return null;
            } else if (drawable instanceof BitmapDrawable) {
                return ((BitmapDrawable) drawable).getBitmap();
            }

            try {
                // Create Bitmap object out of the drawable
                Bitmap bitmap = Bitmap.createBitmap(drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable.draw(canvas);
                return bitmap;
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        //endregion

        //region Measure Method
        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int width = measureWidth(widthMeasureSpec);
            int height = measureHeight(heightMeasureSpec);
            setMeasuredDimension(width, height);
        }

        private int measureWidth(int measureSpec) {
            int result;
            int specMode = MeasureSpec.getMode(measureSpec);
            int specSize = MeasureSpec.getSize(measureSpec);

            if (specMode == MeasureSpec.EXACTLY) {
                // The parent has determined an exact size for the child.
                result = specSize;
            } else if (specMode == MeasureSpec.AT_MOST) {
                // The child can be as large as it wants up to the specified size.
                result = specSize;
            } else {
                // The parent has not imposed any constraint on the child.
                result = canvasSize;
            }

            return result;
        }

        private int measureHeight(int measureSpecHeight) {
            int result;
            int specMode = MeasureSpec.getMode(measureSpecHeight);
            int specSize = MeasureSpec.getSize(measureSpecHeight);

            if (specMode == MeasureSpec.EXACTLY) {
                // We were told how big to be
                result = specSize;
            } else if (specMode == MeasureSpec.AT_MOST) {
                // The child can be as large as it wants up to the specified size.
                result = specSize;
            } else {
                // Measure the text (beware: ascent is a negative number)
                result = canvasSize;
            }

            return result + 2;
        }
        //endregion

        public enum ShadowGravity {
            CENTER,
            TOP,
            BOTTOM,
            START,
            END;

            public int getValue() {
                switch (this) {
                    case CENTER:
                        return 1;
                    case TOP:
                        return 2;
                    case BOTTOM:
                        return 3;
                    case START:
                        return 4;
                    case END:
                        return 5;
                }
                throw new IllegalArgumentException("Not value available for this ShadowGravity: " + this);
            }

            public static ShadowGravity fromValue(int value) {
                switch (value) {
                    case 1:
                        return CENTER;
                    case 2:
                        return TOP;
                    case 3:
                        return BOTTOM;
                    case 4:
                        return START;
                    case 5:
                        return END;
                }
                throw new IllegalArgumentException("This value is not supported for ShadowGravity: " + value);
            }

        }
    }

    public static class CropImage {
        public static final int REQUEST_CROP = 6709;
        public static final int REQUEST_PICK = 9162;
        public static int RESULT_ERROR = 404;

        interface Extra {
            String ASPECT_X = "aspect_x";
            String ASPECT_Y = "aspect_y";
            String MAX_X = "max_x";
            String MAX_Y = "max_y";
            String AS_PNG = "as_png";
            String ERROR = "error";
        }

        private Intent cropIntent;

        public static CropImage of(Uri source, Uri destination) {
            return new CropImage(source, destination);
        }

        public CropImage(Uri source, Uri destination) {
            cropIntent = new Intent();
            cropIntent.setData(source);
            cropIntent.putExtra(MediaStore.EXTRA_OUTPUT, destination);
        }

        public CropImage withAspect(int x, int y) {
            cropIntent.putExtra(Extra.ASPECT_X, x);
            cropIntent.putExtra(Extra.ASPECT_Y, y);
            return this;
        }

        public CropImage asSquare() {
            cropIntent.putExtra(Extra.ASPECT_X, 1);
            cropIntent.putExtra(Extra.ASPECT_Y, 1);
            return this;
        }


        public CropImage withMaxSize(int width, int height) {
            cropIntent.putExtra(Extra.MAX_X, width);
            cropIntent.putExtra(Extra.MAX_Y, height);
            return this;
        }

        public CropImage asPng(boolean asPng) {
            cropIntent.putExtra(Extra.AS_PNG, asPng);
            return this;
        }


        public void start(Activity activity) {
            start(activity, REQUEST_CROP);
        }


        public void start(Activity activity, int requestCode) {
            activity.startActivityForResult(getIntent(activity), requestCode);
        }

        public void start(Context context, Fragment fragment) {
            start(context, fragment, REQUEST_CROP);
        }

        public void start(Context context, android.support.v4.app.Fragment fragment) {
            start(context, fragment, REQUEST_CROP);
        }

        @TargetApi(Build.VERSION_CODES.HONEYCOMB)
        public void start(Context context, Fragment fragment, int requestCode) {
            fragment.startActivityForResult(getIntent(context), requestCode);
        }

        public void start(Context context, android.support.v4.app.Fragment fragment, int requestCode) {
            fragment.startActivityForResult(getIntent(context), requestCode);
        }

        public Intent getIntent(Context context) {
            cropIntent.setClass(context, CropImageActivity.class);
            return cropIntent;
        }

        public static Uri getOutput(Intent result) {
            return result.getParcelableExtra(MediaStore.EXTRA_OUTPUT);
        }


        public static Throwable getError(Intent result) {
            return (Throwable) result.getSerializableExtra(Extra.ERROR);
        }

        public static void pickImage(Activity activity) {
            pickImage(activity, REQUEST_PICK);
        }


        public static void pickImage(Context context, Fragment fragment) {
            pickImage(context, fragment, REQUEST_PICK);
        }

        public static void pickImage(Context context, android.support.v4.app.Fragment fragment) {
            pickImage(context, fragment, REQUEST_PICK);
        }

        public static void pickImage(Activity activity, int requestCode) {
            try {
                activity.startActivityForResult(getImagePicker(), requestCode);
            } catch (ActivityNotFoundException e) {
                showImagePickerError(activity);
            }
        }


        public static void pickImage(Context context, Fragment fragment, int requestCode) {
            try {
                fragment.startActivityForResult(getImagePicker(), requestCode);
            } catch (ActivityNotFoundException e) {
                showImagePickerError(context);
            }
        }

        public static void pickImage(Context context, android.support.v4.app.Fragment fragment, int requestCode) {
            try {
                fragment.startActivityForResult(getImagePicker(), requestCode);
            } catch (ActivityNotFoundException e) {
                showImagePickerError(context);
            }
        }

        private static Intent getImagePicker() {
            return new Intent(Intent.ACTION_GET_CONTENT).setType("image/*");
        }

        private static void showImagePickerError(Context context) {
            Toast.makeText(context.getApplicationContext(), R.string.crop__pick_error, Toast.LENGTH_SHORT).show();
        }

        public void beginCrop(Activity activity, Uri source) {
            Uri destination = Uri.fromFile(new File(activity.getCacheDir(), "cropped"));
            CropImage.of(source, destination).asPng(true).start(activity);
        }

        private void handleCrop(Context context, int resultCode, Intent result, ImageView imageView) {
            if (resultCode == RESULT_OK) {
                imageView.setImageResource(0);
                imageView.setImageURI(CropImage.getOutput(result));
            } else if (resultCode == RESULT_ERROR) {
                Toast.makeText(context, CropImage.getError(result).getMessage(), Toast.LENGTH_SHORT).show();
            }
        }

        public static void activityResult(Activity activity, ImageView imageView, int requestCode, int resultCode, Intent result) {
            if (requestCode == REQUEST_PICK && resultCode == RESULT_OK) {
//                beginCrop(activity, result.getData());
                Uri destination = Uri.fromFile(new File(activity.getCacheDir(), "cropped"));
                CropImage.of(result.getData(), destination).asPng(true).start(activity);

            } else if (requestCode == REQUEST_CROP) {
//                handleCrop(activity.getApplicationContext(), resultCode, result, imageView);
                if (resultCode == RESULT_OK) {
                    imageView.setImageResource(0);
                    imageView.setImageURI(CropImage.getOutput(result));
                } else if (resultCode == RESULT_ERROR) {
                    Toast.makeText(activity.getApplicationContext(), CropImage.getError(result).getMessage(), Toast.LENGTH_SHORT).show();
                }
            }
        }
    }
}
