package com.yaantra.neeraj.serviceslib;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class ServicePost {

    public static Context context;
    public static int connection_time_out = 240000;

    public static ServicePost instance;

    public ServicePost(Context context) {
        this.context = context;
    }

    public static synchronized ServicePost getInstance (Context context){
        if(null == instance){
            instance = new ServicePost(context);
        }
        return instance;
    }

    public class PostClass extends AsyncTask<String, Void, String> {

        public InstantData<String> instantDatas;
        public String urll = "";
        public String urlParameters = "";

        public PostClass(String url, String urlParameters, final InstantData<String> instantData){
            this.instantDatas =  instantData;
            this.urll =  url;
            this.urlParameters = urlParameters;
        }

        @Override
        protected String doInBackground(String... params) {
            try {
                System.out.println("\nPOST URL: " + urll);
                System.out.println("POST PARAMETER: " + urlParameters);

                URL url = new URL(urll);

                HttpURLConnection connection = (HttpURLConnection) url.openConnection();
                Log.e("Library TAG","Please set Url Header in strings.xml class as: Content_Type & Authorization");
                connection.setRequestProperty("Content-Type", context.getResources().getString(R.string.Content_Type));
                connection.setRequestProperty("Authorization", context.getResources().getString(R.string.Authorization));

                connection.setRequestMethod("POST");
                DataOutputStream dStream = new DataOutputStream(connection.getOutputStream());
                dStream.writeBytes(urlParameters);
                dStream.flush();
                dStream.close();
                int responseCode = connection.getResponseCode();

                if (responseCode == 404){
                    instantDatas.getResponseError("Error:404");
                }
                if (responseCode == 500){
                    instantDatas.getResponseError("Error:500");
                }
                final StringBuilder output = new StringBuilder("Request URL " + url);
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = "";
                final StringBuilder responseOutput = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    responseOutput.append(line);
                }
                br.close();

                output.append(System.getProperty("line.separator") + "Response " + System.getProperty("line.separator") + System.getProperty("line.separator") + responseOutput.toString());
                return responseOutput.toString();

            } catch (MalformedURLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                instantDatas.getResponseError("Error: "+e.getMessage());
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                instantDatas.getResponseError("Error: "+e.getMessage());
            }
            return null;
        }

        @Override
        protected void onPostExecute(String result) {
            super.onPostExecute(result);
            System.out.println("Return Response = "+ result);
            if (result== null){
                instantDatas.getResponse("error");
            } else {
                instantDatas.getResponse(result);
            }
        }
    }

    public void GetApi(final String url , final InstantData<String> instantData){
        System.out.println("\nGET URL: " + url);

        RequestQueue queue = Volley.newRequestQueue(context);
        StringRequest stringRequest = new StringRequest(Request.Method.GET, url,
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String response) {
                        instantData.getResponse(response);
                        System.out.println("Response: " + response);
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                instantData.getResponseError("Error");
                System.out.println("Error: " + error.getMessage());
            }
        });
        stringRequest.setRetryPolicy(new DefaultRetryPolicy(connection_time_out,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        queue.add(stringRequest);
    }
}
