/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.zlang;

import xiaofei.library.zlang.Opr;
import xiaofei.library.zlang.OprAdapter;
import xiaofei.library.zlang.PrimitiveConverter;

class OprAdapterFactory {
    OprAdapterFactory() {
    }

    static OprAdapter getInstance(Opr opr) {
        switch (opr) {
            case NEGATIVE: {
                return NegativeAdapter.INSTANCE;
            }
            case PLUS: {
                return PlusAdapter.INSTANCE;
            }
            case MINUS: {
                return MinusAdapter.INSTANCE;
            }
            case TIMES: {
                return TimesAdapter.INSTANCE;
            }
            case DIVIDE: {
                return DivideAdapter.INSTANCE;
            }
            case EQUAL: {
                return EqualAdapter.INSTANCE;
            }
            case NOT_EQUAL: {
                return NotEqualAdapter.INSTANCE;
            }
            case LESS: {
                return LessAdapter.INSTANCE;
            }
            case LESS_EQUAL: {
                return LessEqualAdapter.INSTANCE;
            }
            case GREATER: {
                return GreaterAdapter.INSTANCE;
            }
            case GREATER_EQUAL: {
                return GreaterEqualAdapter.INSTANCE;
            }
            case NOT: {
                return NotAdapter.INSTANCE;
            }
            case AND: {
                return AndAdapter.INSTANCE;
            }
            case OR: {
                return OrAdapter.INSTANCE;
            }
        }
        throw new IllegalArgumentException();
    }

    private static class OrAdapter
    implements OprAdapter {
        static final OrAdapter INSTANCE = new OrAdapter();

        private OrAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 instanceof Boolean && o2 instanceof Boolean) {
                return (Boolean)o1 == false || (Boolean)o2 != false;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class AndAdapter
    implements OprAdapter {
        static final AndAdapter INSTANCE = new AndAdapter();

        private AndAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 instanceof Boolean && o2 instanceof Boolean) {
                return (Boolean)o1 != false && (Boolean)o2 != false;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class NotAdapter
    implements OprAdapter {
        static final NotAdapter INSTANCE = new NotAdapter();

        private NotAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 1;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object operand = stack[start];
            if (operand instanceof Boolean) {
                return (Boolean)operand == false;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class GreaterEqualAdapter
    implements OprAdapter {
        static final GreaterEqualAdapter INSTANCE = new GreaterEqualAdapter();

        private GreaterEqualAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            Class<?> clazz = PrimitiveConverter.get(o1, o2);
            if (clazz == Byte.class) {
                return (Byte)o1 >= (Byte)o2;
            }
            if (clazz == Character.class) {
                return ((Character)o1).charValue() >= ((Character)o2).charValue();
            }
            if (clazz == Short.class) {
                return (Short)o1 >= (Short)o2;
            }
            if (clazz == Integer.class) {
                return (Integer)o1 >= (Integer)o2;
            }
            if (clazz == Long.class) {
                return (Long)o1 >= (Long)o2;
            }
            if (clazz == Float.class) {
                return ((Float)o1).floatValue() >= ((Float)o2).floatValue();
            }
            if (clazz == Double.class) {
                return (Double)o1 >= (Double)o2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class GreaterAdapter
    implements OprAdapter {
        static final GreaterAdapter INSTANCE = new GreaterAdapter();

        private GreaterAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            Class<?> clazz = PrimitiveConverter.get(o1, o2);
            if (clazz == Byte.class) {
                return (Byte)o1 > (Byte)o2;
            }
            if (clazz == Character.class) {
                return ((Character)o1).charValue() > ((Character)o2).charValue();
            }
            if (clazz == Short.class) {
                return (Short)o1 > (Short)o2;
            }
            if (clazz == Integer.class) {
                return (Integer)o1 > (Integer)o2;
            }
            if (clazz == Long.class) {
                return (Long)o1 > (Long)o2;
            }
            if (clazz == Float.class) {
                return ((Float)o1).floatValue() > ((Float)o2).floatValue();
            }
            if (clazz == Double.class) {
                return (Double)o1 > (Double)o2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class LessEqualAdapter
    implements OprAdapter {
        static final LessEqualAdapter INSTANCE = new LessEqualAdapter();

        private LessEqualAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            Class<?> clazz = PrimitiveConverter.get(o1, o2);
            if (clazz == Byte.class) {
                return (Byte)o1 <= (Byte)o2;
            }
            if (clazz == Character.class) {
                return ((Character)o1).charValue() <= ((Character)o2).charValue();
            }
            if (clazz == Short.class) {
                return (Short)o1 <= (Short)o2;
            }
            if (clazz == Integer.class) {
                return (Integer)o1 <= (Integer)o2;
            }
            if (clazz == Long.class) {
                return (Long)o1 <= (Long)o2;
            }
            if (clazz == Float.class) {
                return ((Float)o1).floatValue() <= ((Float)o2).floatValue();
            }
            if (clazz == Double.class) {
                return (Double)o1 <= (Double)o2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class LessAdapter
    implements OprAdapter {
        static final LessAdapter INSTANCE = new LessAdapter();

        private LessAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            Class<?> clazz = PrimitiveConverter.get(o1, o2);
            if (clazz == Byte.class) {
                return (Byte)o1 < (Byte)o2;
            }
            if (clazz == Character.class) {
                return ((Character)o1).charValue() < ((Character)o2).charValue();
            }
            if (clazz == Short.class) {
                return (Short)o1 < (Short)o2;
            }
            if (clazz == Integer.class) {
                return (Integer)o1 < (Integer)o2;
            }
            if (clazz == Long.class) {
                return (Long)o1 < (Long)o2;
            }
            if (clazz == Float.class) {
                return ((Float)o1).floatValue() < ((Float)o2).floatValue();
            }
            if (clazz == Double.class) {
                return (Double)o1 < (Double)o2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class NotEqualAdapter
    implements OprAdapter {
        static final NotEqualAdapter INSTANCE = new NotEqualAdapter();

        private NotEqualAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            return stack[start] != stack[start + 1];
        }
    }

    private static class EqualAdapter
    implements OprAdapter {
        static final EqualAdapter INSTANCE = new EqualAdapter();

        private EqualAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            return stack[start] == stack[start + 1];
        }
    }

    private static class DivideAdapter
    implements OprAdapter {
        static final DivideAdapter INSTANCE = new DivideAdapter();

        private DivideAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            Class<?> clazz = PrimitiveConverter.get(o1, o2);
            if (clazz == Byte.class) {
                return (Byte)o1 / (Byte)o2;
            }
            if (clazz == Character.class) {
                return ((Character)o1).charValue() / ((Character)o2).charValue();
            }
            if (clazz == Short.class) {
                return (Short)o1 / (Short)o2;
            }
            if (clazz == Integer.class) {
                return (Integer)o1 / (Integer)o2;
            }
            if (clazz == Long.class) {
                return (Long)o1 / (Long)o2;
            }
            if (clazz == Float.class) {
                return Float.valueOf(((Float)o1).floatValue() / ((Float)o2).floatValue());
            }
            if (clazz == Double.class) {
                return (Double)o1 / (Double)o2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class TimesAdapter
    implements OprAdapter {
        static final TimesAdapter INSTANCE = new TimesAdapter();

        private TimesAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            Class<?> clazz = PrimitiveConverter.get(o1, o2);
            if (clazz == Byte.class) {
                return (Byte)o1 * (Byte)o2;
            }
            if (clazz == Character.class) {
                return ((Character)o1).charValue() * ((Character)o2).charValue();
            }
            if (clazz == Short.class) {
                return (Short)o1 * (Short)o2;
            }
            if (clazz == Integer.class) {
                return (Integer)o1 * (Integer)o2;
            }
            if (clazz == Long.class) {
                return (Long)o1 * (Long)o2;
            }
            if (clazz == Float.class) {
                return Float.valueOf(((Float)o1).floatValue() * ((Float)o2).floatValue());
            }
            if (clazz == Double.class) {
                return (Double)o1 * (Double)o2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class MinusAdapter
    implements OprAdapter {
        static final MinusAdapter INSTANCE = new MinusAdapter();

        private MinusAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            Class<?> clazz = PrimitiveConverter.get(o1, o2);
            if (clazz == Byte.class) {
                return (Byte)o1 - (Byte)o2;
            }
            if (clazz == Character.class) {
                return ((Character)o1).charValue() - ((Character)o2).charValue();
            }
            if (clazz == Short.class) {
                return (Short)o1 - (Short)o2;
            }
            if (clazz == Integer.class) {
                return (Integer)o1 - (Integer)o2;
            }
            if (clazz == Long.class) {
                return (Long)o1 - (Long)o2;
            }
            if (clazz == Float.class) {
                return Float.valueOf(((Float)o1).floatValue() - ((Float)o2).floatValue());
            }
            if (clazz == Double.class) {
                return (Double)o1 - (Double)o2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class PlusAdapter
    implements OprAdapter {
        static final PlusAdapter INSTANCE = new PlusAdapter();

        private PlusAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 2;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object o1 = stack[start];
            Object o2 = stack[start + 1];
            if (o1 == null && o2 == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            if (o1 instanceof String) {
                return (String)o1 + o2;
            }
            if (o2 instanceof String) {
                return o1 + (String)o2;
            }
            Class<?> clazz = PrimitiveConverter.get(o1, o2);
            if (clazz == Byte.class) {
                return (Byte)o1 + (Byte)o2;
            }
            if (clazz == Character.class) {
                return ((Character)o1).charValue() + ((Character)o2).charValue();
            }
            if (clazz == Short.class) {
                return (Short)o1 + (Short)o2;
            }
            if (clazz == Integer.class) {
                return (Integer)o1 + (Integer)o2;
            }
            if (clazz == Long.class) {
                return (Long)o1 + (Long)o2;
            }
            if (clazz == Float.class) {
                return Float.valueOf(((Float)o1).floatValue() + ((Float)o2).floatValue());
            }
            if (clazz == Double.class) {
                return (Double)o1 + (Double)o2;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class NegativeAdapter
    implements OprAdapter {
        static final NegativeAdapter INSTANCE = new NegativeAdapter();

        private NegativeAdapter() {
        }

        @Override
        public int getOperandNumber() {
            return 1;
        }

        @Override
        public Object operate(Object[] stack, int start) {
            Object operand = stack[start];
            if (operand == null) {
                throw new NullPointerException("Null is not allowed.");
            }
            if (operand instanceof Byte) {
                return (int)(-((Byte)operand).byteValue());
            }
            if (operand instanceof Character) {
                return (int)(-((Character)operand).charValue());
            }
            if (operand instanceof Short) {
                return (int)(-((Short)operand).shortValue());
            }
            if (operand instanceof Integer) {
                return -((Integer)operand).intValue();
            }
            if (operand instanceof Long) {
                return -((Long)operand).longValue();
            }
            if (operand instanceof Float) {
                return Float.valueOf(-((Float)operand).floatValue());
            }
            if (operand instanceof Double) {
                return -((Double)operand).doubleValue();
            }
            throw new IllegalArgumentException();
        }
    }
}

