/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.zlang;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import xiaofei.library.zlang.JavaFunction;

public abstract class JavaLibrary {
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, JavaFunction>> fixedArgsFunctions = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<JavaFunction>> varArgsFunctions = new ConcurrentHashMap();

    protected JavaLibrary() {
        JavaFunction[] functions;
        for (JavaFunction function : functions = this.onProvideJavaFunctions()) {
            this.addFunction(function);
        }
    }

    protected abstract JavaFunction[] onProvideJavaFunctions();

    private void addFunction(JavaFunction function) {
        String name = function.getFunctionName();
        if (function.isVarArgs()) {
            ConcurrentLinkedQueue<JavaFunction> list = this.varArgsFunctions.get(name);
            if (list == null) {
                list = new ConcurrentLinkedQueue();
                this.varArgsFunctions.put(name, list);
            }
            list.add(function);
        } else {
            ConcurrentHashMap<Integer, JavaFunction> map = this.fixedArgsFunctions.get(name);
            if (map == null) {
                map = new ConcurrentHashMap();
                this.fixedArgsFunctions.put(name, map);
            }
            map.put(function.getParameterNumber(), function);
        }
    }

    final JavaFunction get(String functionName, int parameterNumber) {
        JavaFunction function;
        ConcurrentHashMap<Integer, JavaFunction> functionMap = this.fixedArgsFunctions.get(functionName);
        if (functionMap != null && (function = functionMap.get(parameterNumber)) != null) {
            return function;
        }
        ConcurrentLinkedQueue<JavaFunction> functionList = this.varArgsFunctions.get(functionName);
        if (functionList == null) {
            return null;
        }
        for (JavaFunction function2 : functionList) {
            if (parameterNumber < function2.getParameterNumber()) continue;
            return function2;
        }
        return null;
    }

    public static class Builder {
        private final ArrayList<JavaFunction> functions = new ArrayList();

        public Builder addFunctions(JavaFunction[] functions) {
            for (JavaFunction function : functions) {
                this.addFunction(function);
            }
            return this;
        }

        public Builder addFunction(JavaFunction function) {
            this.functions.add(function);
            return this;
        }

        public JavaLibrary build() {
            return new JavaLibrary(){

                @Override
                protected JavaFunction[] onProvideJavaFunctions() {
                    int length = Builder.this.functions.size();
                    JavaFunction[] result = new JavaFunction[length];
                    for (int i = 0; i < length; ++i) {
                        result[i] = (JavaFunction)Builder.this.functions.get(i);
                    }
                    return result;
                }
            };
        }
    }
}

