/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.zlang;

import java.util.ArrayList;
import java.util.HashMap;
import xiaofei.library.zlang.Code;
import xiaofei.library.zlang.CompileError;
import xiaofei.library.zlang.CompileException;
import xiaofei.library.zlang.Compiler;
import xiaofei.library.zlang.Executor;
import xiaofei.library.zlang.InternalJavaFunctions;
import xiaofei.library.zlang.JavaFunction;
import xiaofei.library.zlang.JavaLibrary;

public class Library {
    public static final Object NO_RETURN_VALUE = Executor.NO_RETURN_VALUE;
    private ArrayList<Library> dependencies = null;
    private ArrayList<JavaLibrary> javaDependencies = null;
    private HashMap<String, HashMap<Integer, ArrayList<Code>>> codeMap = null;
    private String program = null;

    private Library() {
    }

    boolean containsFunction(String functionName, int parameterNumber) {
        if (this.codeMap == null) {
            throw new CompileException(CompileError.NOT_COMPILED, -1, -1, "Library " + this + " is not compiled.");
        }
        HashMap<Integer, ArrayList<Code>> codes = this.codeMap.get(functionName);
        if (codes != null && codes.containsKey(parameterNumber)) {
            return true;
        }
        for (JavaLibrary javaLibrary : this.javaDependencies) {
            if (javaLibrary.get(functionName, parameterNumber) == null) continue;
            return true;
        }
        for (Library library : this.dependencies) {
            if (!library.containsFunction(functionName, parameterNumber)) continue;
            return true;
        }
        return false;
    }

    JavaFunction getJavaFunction(String functionName, int parameter) {
        JavaFunction function;
        for (JavaLibrary javaLibrary : this.javaDependencies) {
            function = javaLibrary.get(functionName, parameter);
            if (function == null) continue;
            return function;
        }
        for (Library library : this.dependencies) {
            function = library.getJavaFunction(functionName, parameter);
            if (function == null) continue;
            return function;
        }
        return null;
    }

    FunctionSearchResult getFunction(String functionName, int parameterNumber) {
        if (this.codeMap == null) {
            throw new CompileException(CompileError.NOT_COMPILED, -1, -1, "Library " + this + " is not compiled.");
        }
        HashMap<Integer, ArrayList<Code>> codes = this.codeMap.get(functionName);
        ArrayList<Code> code = null;
        if (codes != null) {
            code = codes.get(parameterNumber);
        }
        if (code != null) {
            return new FunctionSearchResult(this, code);
        }
        for (Library library : this.dependencies) {
            FunctionSearchResult result = library.getFunction(functionName, parameterNumber);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    void put(String functionName, int parameterNumber, ArrayList<Code> codesToPut) {
        HashMap<Integer, ArrayList<Code>> codes = this.codeMap.get(functionName);
        if (codes == null) {
            codes = new HashMap();
            this.codeMap.put(functionName, codes);
        }
        if (codes.put(parameterNumber, codesToPut) != null) {
            throw new CompileException(CompileError.FUNCTION_ALREADY_EXIST, -1, -1, "function name: " + functionName + " parameter number: " + parameterNumber);
        }
    }

    private void compile() {
        if (this.codeMap != null) {
            return;
        }
        this.codeMap = new HashMap();
        new Compiler(this).compile();
    }

    public Object execute(String functionName, Object[] input) {
        return Executor.execute(this, functionName, input);
    }

    String getProgram() {
        return this.program;
    }

    void print(String functionName, int parameterNumber) {
        FunctionSearchResult result = this.getFunction(functionName, parameterNumber);
        if (result == null) {
            System.out.println("No such function.");
        } else {
            System.out.println(functionName + " " + parameterNumber);
            int size = result.codes.size();
            for (int i = 0; i < size; ++i) {
                Code code = result.codes.get(i);
                System.out.println(i + "\t" + (Object)((Object)code.getOpr()) + "\t" + code.getOperand());
            }
            System.out.println("End.");
        }
    }

    static class FunctionSearchResult {
        final Library library;
        final ArrayList<Code> codes;

        FunctionSearchResult(Library library, ArrayList<Code> codes) {
            this.library = library;
            this.codes = codes;
        }
    }

    public static class Builder {
        private StringBuilder program = new StringBuilder();
        private ArrayList<Library> dependencies = new ArrayList();
        private ArrayList<JavaLibrary> javaDependencies = new ArrayList();

        public Builder addFunctions(String functions) {
            this.program.append(functions).append('\n');
            return this;
        }

        public Builder addDependency(Library library) {
            this.dependencies.add(library);
            return this;
        }

        public Builder addJavaDependency(JavaLibrary library) {
            this.javaDependencies.add(library);
            return this;
        }

        public Library build() {
            Library library = new Library();
            library.dependencies = this.dependencies;
            ArrayList<JavaLibrary> javaLibraries = new ArrayList<JavaLibrary>();
            javaLibraries.add(InternalJavaFunctions.INSTANCE);
            javaLibraries.addAll(this.javaDependencies);
            library.javaDependencies = javaLibraries;
            library.program = this.program.toString();
            library.compile();
            return library;
        }
    }
}

