/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.zlang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import xiaofei.library.zlang.JavaFunction;

public abstract class JavaLibrary {
    private final HashMap<String, HashMap<Integer, JavaFunction>> fixedArgsFunctions = new HashMap();
    private final HashMap<String, LinkedList<JavaFunction>> varArgsFunctions = new HashMap();

    protected JavaLibrary() {
        JavaFunction[] functions;
        for (JavaFunction function : functions = this.onProvideJavaFunctions()) {
            this.addFunction(function);
        }
    }

    protected abstract JavaFunction[] onProvideJavaFunctions();

    private void addFunction(JavaFunction function) {
        String name = function.getFunctionName();
        if (function.isVarArgs()) {
            LinkedList<JavaFunction> list = this.varArgsFunctions.get(name);
            if (list == null) {
                list = new LinkedList();
                this.varArgsFunctions.put(name, list);
            }
            list.add(function);
        } else {
            HashMap<Integer, JavaFunction> map = this.fixedArgsFunctions.get(name);
            if (map == null) {
                map = new HashMap();
                this.fixedArgsFunctions.put(name, map);
            }
            map.put(function.getParameterNumber(), function);
        }
    }

    final JavaFunction get(String functionName, int parameterNumber) {
        JavaFunction function;
        HashMap<Integer, JavaFunction> functionMap = this.fixedArgsFunctions.get(functionName);
        if (functionMap != null && (function = functionMap.get(parameterNumber)) != null) {
            return function;
        }
        LinkedList<JavaFunction> functionList = this.varArgsFunctions.get(functionName);
        if (functionList == null) {
            return null;
        }
        for (JavaFunction function2 : functionList) {
            if (parameterNumber < function2.getParameterNumber()) continue;
            return function2;
        }
        return null;
    }

    public static class Builder {
        private final ArrayList<JavaFunction> functions = new ArrayList();

        public Builder addFunctions(JavaFunction[] functions) {
            for (JavaFunction function : functions) {
                this.addFunction(function);
            }
            return this;
        }

        public Builder addFunction(JavaFunction function) {
            this.functions.add(function);
            return this;
        }

        public JavaLibrary build() {
            return new JavaLibrary(){

                @Override
                protected JavaFunction[] onProvideJavaFunctions() {
                    int length = Builder.this.functions.size();
                    JavaFunction[] result = new JavaFunction[length];
                    for (int i = 0; i < length; ++i) {
                        result[i] = (JavaFunction)Builder.this.functions.get(i);
                    }
                    return result;
                }
            };
        }
    }
}

