/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.zlang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import xiaofei.library.zlang.Code;
import xiaofei.library.zlang.CompileError;
import xiaofei.library.zlang.CompileException;
import xiaofei.library.zlang.Fct;
import xiaofei.library.zlang.Library;
import xiaofei.library.zlang.Opr;
import xiaofei.library.zlang.Symbol;

class Compiler {
    private static final Set<Character> SPACE_CHARS = new HashSet<Character>(){
        {
            this.add(Character.valueOf(' '));
            this.add(Character.valueOf('\t'));
            this.add(Character.valueOf('\n'));
        }
    };
    private static final HashMap<String, Symbol> RESERVED_WORDS_SYMBOLS = new HashMap<String, Symbol>(){
        {
            this.put("END", Symbol.END);
            this.put("function", Symbol.FUNCTION);
            this.put("if", Symbol.IF);
            this.put("else", Symbol.ELSE);
            this.put("while", Symbol.WHILE);
            this.put("for", Symbol.FOR);
            this.put("to", Symbol.TO);
            this.put("step", Symbol.STEP);
            this.put("break", Symbol.BREAK);
            this.put("continue", Symbol.CONTINUE);
            this.put("return", Symbol.RETURN);
        }
    };
    private static final HashSet<Symbol> LEADING_WORDS = new HashSet<Symbol>(){
        {
            this.add(Symbol.IF);
            this.add(Symbol.WHILE);
            this.add(Symbol.FOR);
            this.add(Symbol.BREAK);
            this.add(Symbol.CONTINUE);
            this.add(Symbol.RETURN);
        }
    };
    private static final HashMap<Character, Symbol> CHARACTER_SYMBOLS = new HashMap<Character, Symbol>(){
        {
            this.put(Character.valueOf(','), Symbol.COMMA);
            this.put(Character.valueOf(';'), Symbol.SEMICOLON);
            this.put(Character.valueOf('('), Symbol.LEFT_PARENTHESIS);
            this.put(Character.valueOf(')'), Symbol.RIGHT_PARENTHESIS);
            this.put(Character.valueOf('{'), Symbol.LEFT_BRACE);
            this.put(Character.valueOf('}'), Symbol.RIGHT_BRACE);
            this.put(Character.valueOf('['), Symbol.LEFT_BRACKET);
            this.put(Character.valueOf(']'), Symbol.RIGHT_BRACKET);
            this.put(Character.valueOf('+'), Symbol.PLUS);
            this.put(Character.valueOf('-'), Symbol.MINUS);
            this.put(Character.valueOf('*'), Symbol.TIMES);
            this.put(Character.valueOf('/'), Symbol.DIVIDE);
        }
    };
    private int pos = -1;
    private int lineNumber = 1;
    private int linePos = 0;
    private int previousLinePos;
    private char nextChar = (char)32;
    private Symbol nextSymbol;
    private Object nextObject;
    private int offset;
    private int codeIndex;
    private LabelRecorder continueRecorder = new LabelRecorder();
    private LabelRecorder breakRecorder = new LabelRecorder();
    private Map<String, Integer> symbolTable = new HashMap<String, Integer>();
    private LinkedList<FunctionWrapper> neededFunctions = new LinkedList();
    private Library library;
    private String program;
    private ArrayList<Code> codes;

    Compiler(Library library) {
        this.program = library.getProgram();
        this.library = library;
    }

    private static boolean isAlpha(char ch) {
        return ch == '_' || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z';
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private void moveToNextChar() {
        if (++this.pos == this.program.length()) {
            throw new CompileException(CompileError.INCOMPLETE_PROGRAM, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "Program incomplete!");
        }
        this.nextChar = this.program.charAt(this.pos);
        if (this.nextChar == '\n') {
            ++this.lineNumber;
            this.linePos = 0;
        } else {
            ++this.linePos;
        }
    }

    private void moveToNextSymbol() {
        while (SPACE_CHARS.contains(Character.valueOf(this.nextChar))) {
            this.moveToNextChar();
        }
        while (this.nextChar == '/' && this.program.charAt(this.pos + 1) == '*') {
            char tmp;
            this.moveToNextChar();
            this.moveToNextChar();
            do {
                tmp = this.nextChar;
                this.moveToNextChar();
            } while (tmp != '*' || this.nextChar != '/');
            this.moveToNextChar();
            while (SPACE_CHARS.contains(Character.valueOf(this.nextChar))) {
                this.moveToNextChar();
            }
        }
        this.previousLinePos = this.linePos;
        if (Compiler.isAlpha(this.nextChar)) {
            String id = "";
            do {
                id = id + this.nextChar;
                this.moveToNextChar();
            } while (Compiler.isAlpha(this.nextChar) || Compiler.isDigit(this.nextChar));
            if (RESERVED_WORDS_SYMBOLS.containsKey(id)) {
                this.nextSymbol = RESERVED_WORDS_SYMBOLS.get(id);
                this.nextObject = this.nextSymbol;
            } else if (id.equals("true") || id.equals("false")) {
                this.nextSymbol = Symbol.BOOLEAN;
                this.nextObject = id.equals("true");
            } else if (id.equals("null")) {
                this.nextSymbol = Symbol.NULL;
                this.nextObject = null;
            } else {
                this.nextSymbol = Symbol.ID;
                this.nextObject = id;
            }
        } else if (Compiler.isDigit(this.nextChar)) {
            this.nextSymbol = Symbol.NUMBER;
            int intNum = this.nextChar - 48;
            this.moveToNextChar();
            while (Compiler.isDigit(this.nextChar)) {
                intNum = intNum * 10 + this.nextChar - 48;
                this.moveToNextChar();
            }
            if (this.nextChar == '.') {
                double doubleNum = intNum;
                double tmp = 1.0;
                this.moveToNextChar();
                while (Compiler.isDigit(this.nextChar)) {
                    doubleNum += (tmp /= 10.0) * (double)(this.nextChar - 48);
                    this.moveToNextChar();
                }
                this.nextObject = doubleNum;
            } else {
                this.nextObject = intNum;
            }
        } else if (this.nextChar == '\'') {
            this.nextSymbol = Symbol.CHARACTER;
            this.moveToNextChar();
            if (this.nextChar == '\\') {
                this.moveToNextChar();
            }
            this.nextObject = Character.valueOf(this.nextChar);
            this.moveToNextChar();
            this.moveToNextChar();
        } else if (this.nextChar == '\"') {
            this.nextSymbol = Symbol.STRING;
            String data = "";
            this.moveToNextChar();
            while (this.nextChar != '\"') {
                if (this.nextChar == '\\') {
                    this.moveToNextChar();
                }
                data = data + this.nextChar;
                this.moveToNextChar();
            }
            this.nextObject = data;
            this.moveToNextChar();
        } else if (this.nextChar == '<') {
            this.moveToNextChar();
            if (this.nextChar == '=') {
                this.nextSymbol = Symbol.LESS_EQUAL;
                this.moveToNextChar();
            } else {
                this.nextSymbol = Symbol.LESS;
            }
            this.nextObject = this.nextSymbol;
        } else if (this.nextChar == '>') {
            this.moveToNextChar();
            if (this.nextChar == '=') {
                this.nextSymbol = Symbol.GREATER_EQUAL;
                this.moveToNextChar();
            } else {
                this.nextSymbol = Symbol.GREATER;
            }
            this.nextObject = this.nextSymbol;
        } else if (this.nextChar == '=') {
            this.moveToNextChar();
            if (this.nextChar == '=') {
                this.nextSymbol = Symbol.EQUAL;
                this.moveToNextChar();
            } else {
                this.nextSymbol = Symbol.ASSIGN;
            }
            this.nextObject = this.nextSymbol;
        } else if (this.nextChar == '!') {
            this.moveToNextChar();
            if (this.nextChar == '=') {
                this.nextSymbol = Symbol.NOT_EQUAL;
                this.moveToNextChar();
            } else {
                this.nextSymbol = Symbol.NOT;
            }
            this.nextObject = this.nextSymbol;
        } else if (this.nextChar == '&') {
            this.moveToNextChar();
            if (this.nextChar != '&') {
                throw new CompileException(CompileError.ILLEGAL_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "&");
            }
            this.nextSymbol = Symbol.AND;
            this.moveToNextChar();
            this.nextObject = this.nextSymbol;
        } else if (this.nextChar == '|') {
            this.moveToNextChar();
            if (this.nextChar != '|') {
                throw new CompileException(CompileError.ILLEGAL_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "|");
            }
            this.nextSymbol = Symbol.OR;
            this.moveToNextChar();
            this.nextObject = this.nextSymbol;
        } else {
            this.nextSymbol = CHARACTER_SYMBOLS.get(Character.valueOf(this.nextChar));
            if (this.nextSymbol == null) {
                throw new CompileException(CompileError.ILLEGAL_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, Character.toString(this.nextChar));
            }
            this.nextObject = this.nextSymbol;
            this.moveToNextChar();
        }
    }

    private void generateCode(Fct fct, Object operand) {
        this.codes.add(new Code(fct, operand));
        ++this.codeIndex;
    }

    private void modifyCodeOperand(int codeIndex, Object operand) {
        this.codes.get(codeIndex).setOperand(operand);
    }

    private int callFunction() {
        int parameterNumber = 0;
        this.moveToNextSymbol();
        while (this.nextSymbol != Symbol.RIGHT_PARENTHESIS) {
            this.disjunctionExpression();
            ++parameterNumber;
            if (this.nextSymbol == Symbol.COMMA) {
                this.moveToNextSymbol();
                continue;
            }
            if (this.nextSymbol == Symbol.RIGHT_PARENTHESIS) continue;
            throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ") or ,");
        }
        this.moveToNextSymbol();
        this.generateCode(Fct.LIT, parameterNumber);
        return parameterNumber;
    }

    private void addIntoNeededFunctions(String functionName, int parameterNumber) {
        for (FunctionWrapper functionWrapper : this.neededFunctions) {
            if (!functionWrapper.functionName.equals(functionName) || functionWrapper.parameterNumber != parameterNumber) continue;
            return;
        }
        this.neededFunctions.add(new FunctionWrapper(functionName, parameterNumber));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void factor() {
        if (this.nextSymbol == Symbol.ID) {
            String id = (String)this.nextObject;
            this.moveToNextSymbol();
            if (this.nextSymbol == Symbol.LEFT_PARENTHESIS) {
                int parameterNumber = this.callFunction();
                this.generateCode(Fct.FUN, id);
                this.addIntoNeededFunctions(id, parameterNumber);
                return;
            } else if (this.nextSymbol == Symbol.LEFT_BRACKET) {
                Integer address = this.symbolTable.get(id);
                if (address == null) {
                    throw new CompileException(CompileError.UNINITIALIZED_VARIABLE, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, id);
                }
                int dimens = 0;
                do {
                    ++dimens;
                    this.moveToNextSymbol();
                    this.numericExpression();
                    if (this.nextSymbol != Symbol.RIGHT_BRACKET) {
                        throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "]");
                    }
                    this.moveToNextSymbol();
                } while (this.nextSymbol == Symbol.LEFT_BRACKET);
                this.generateCode(Fct.LIT, dimens);
                this.generateCode(Fct.ALOD, address);
                return;
            } else {
                Integer address = this.symbolTable.get(id);
                if (address == null) {
                    throw new CompileException(CompileError.UNINITIALIZED_VARIABLE, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, id);
                }
                this.generateCode(Fct.LOD, address);
            }
            return;
        } else if (this.nextSymbol == Symbol.NUMBER || this.nextSymbol == Symbol.BOOLEAN || this.nextSymbol == Symbol.CHARACTER || this.nextSymbol == Symbol.STRING || this.nextSymbol == Symbol.NULL) {
            this.generateCode(Fct.LIT, this.nextObject);
            this.moveToNextSymbol();
            return;
        } else if (this.nextSymbol == Symbol.LEFT_PARENTHESIS) {
            this.moveToNextSymbol();
            this.disjunctionExpression();
            if (this.nextSymbol != Symbol.RIGHT_PARENTHESIS) throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ")");
            this.moveToNextSymbol();
            return;
        } else {
            if (this.nextSymbol != Symbol.NOT) throw new CompileException(CompileError.ILLEGAL_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "" + (Object)((Object)this.nextSymbol));
            this.moveToNextSymbol();
            this.factor();
            this.generateCode(Fct.OPR, (Object)Opr.NOT);
        }
    }

    private void term() {
        this.factor();
        while (this.nextSymbol == Symbol.TIMES || this.nextSymbol == Symbol.DIVIDE) {
            Symbol op = this.nextSymbol;
            this.moveToNextSymbol();
            this.factor();
            if (op == Symbol.TIMES) {
                this.generateCode(Fct.OPR, (Object)Opr.TIMES);
                continue;
            }
            if (op != Symbol.DIVIDE) continue;
            this.generateCode(Fct.OPR, (Object)Opr.DIVIDE);
        }
    }

    private void numericExpression() {
        Symbol op;
        if (this.nextSymbol == Symbol.PLUS || this.nextSymbol == Symbol.MINUS) {
            op = this.nextSymbol;
            this.moveToNextSymbol();
            this.term();
            if (op == Symbol.MINUS) {
                this.generateCode(Fct.OPR, (Object)Opr.NEGATIVE);
            }
        } else {
            this.term();
        }
        while (this.nextSymbol == Symbol.PLUS || this.nextSymbol == Symbol.MINUS) {
            op = this.nextSymbol;
            this.moveToNextSymbol();
            this.term();
            if (op == Symbol.PLUS) {
                this.generateCode(Fct.OPR, (Object)Opr.PLUS);
                continue;
            }
            if (op != Symbol.MINUS) continue;
            this.generateCode(Fct.OPR, (Object)Opr.MINUS);
        }
    }

    private void comparisonExpression() {
        this.numericExpression();
        if (this.nextSymbol == Symbol.EQUAL || this.nextSymbol == Symbol.NOT_EQUAL || this.nextSymbol == Symbol.LESS || this.nextSymbol == Symbol.LESS_EQUAL || this.nextSymbol == Symbol.GREATER || this.nextSymbol == Symbol.GREATER_EQUAL) {
            Symbol op = this.nextSymbol;
            this.moveToNextSymbol();
            this.numericExpression();
            if (op == Symbol.EQUAL) {
                this.generateCode(Fct.OPR, (Object)Opr.EQUAL);
            } else if (op == Symbol.NOT_EQUAL) {
                this.generateCode(Fct.OPR, (Object)Opr.NOT_EQUAL);
            } else if (op == Symbol.LESS) {
                this.generateCode(Fct.OPR, (Object)Opr.LESS);
            } else if (op == Symbol.LESS_EQUAL) {
                this.generateCode(Fct.OPR, (Object)Opr.LESS_EQUAL);
            } else if (op == Symbol.GREATER) {
                this.generateCode(Fct.OPR, (Object)Opr.GREATER);
            } else if (op == Symbol.GREATER_EQUAL) {
                this.generateCode(Fct.OPR, (Object)Opr.GREATER_EQUAL);
            }
        }
    }

    private void conjunctionExpression() {
        ArrayList<Integer> codeIndexes = new ArrayList<Integer>();
        this.comparisonExpression();
        while (this.nextSymbol == Symbol.AND) {
            this.generateCode(Fct.JPF_SC, 0);
            codeIndexes.add(this.codeIndex);
            this.moveToNextSymbol();
            this.comparisonExpression();
            this.generateCode(Fct.OPR, (Object)Opr.AND);
        }
        Iterator iterator = codeIndexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.modifyCodeOperand(index, this.codeIndex + 1);
        }
    }

    private void disjunctionExpression() {
        ArrayList<Integer> codeIndexes = new ArrayList<Integer>();
        this.conjunctionExpression();
        while (this.nextSymbol == Symbol.OR) {
            this.generateCode(Fct.JPT_SC, 0);
            codeIndexes.add(this.codeIndex);
            this.moveToNextSymbol();
            this.conjunctionExpression();
            this.generateCode(Fct.OPR, (Object)Opr.OR);
        }
        Iterator iterator = codeIndexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.modifyCodeOperand(index, this.codeIndex + 1);
        }
    }

    private void statement(boolean inLoop) {
        if (this.nextSymbol == Symbol.SEMICOLON) {
            this.moveToNextSymbol();
        } else if (this.nextSymbol == Symbol.ID) {
            String id = (String)this.nextObject;
            this.moveToNextSymbol();
            if (this.nextSymbol == Symbol.ASSIGN) {
                Integer address = this.symbolTable.get(id);
                if (address == null) {
                    address = ++this.offset;
                    this.symbolTable.put(id, address);
                }
                this.moveToNextSymbol();
                this.disjunctionExpression();
                this.generateCode(Fct.STO, address);
            } else if (this.nextSymbol == Symbol.LEFT_PARENTHESIS) {
                int parameterNumber = this.callFunction();
                this.generateCode(Fct.PROC, id);
                this.addIntoNeededFunctions(id, parameterNumber);
            } else if (this.nextSymbol == Symbol.LEFT_BRACKET) {
                Integer address = this.symbolTable.get(id);
                if (address == null) {
                    throw new CompileException(CompileError.UNINITIALIZED_ARRAY, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, id);
                }
                int dimens = 0;
                do {
                    ++dimens;
                    this.moveToNextSymbol();
                    this.numericExpression();
                    if (this.nextSymbol != Symbol.RIGHT_BRACKET) {
                        throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "]");
                    }
                    this.moveToNextSymbol();
                } while (this.nextSymbol == Symbol.LEFT_BRACKET);
                this.generateCode(Fct.LIT, dimens);
                if (this.nextSymbol != Symbol.ASSIGN) {
                    throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "=");
                }
                this.moveToNextSymbol();
                this.disjunctionExpression();
                this.generateCode(Fct.ASTO, address);
            } else {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "= or (");
            }
            if (this.nextSymbol != Symbol.SEMICOLON) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ";");
            }
            this.moveToNextSymbol();
        } else if (this.nextSymbol == Symbol.IF) {
            this.moveToNextSymbol();
            if (this.nextSymbol != Symbol.LEFT_PARENTHESIS) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "(");
            }
            this.moveToNextSymbol();
            this.disjunctionExpression();
            if (this.nextSymbol != Symbol.RIGHT_PARENTHESIS) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ")");
            }
            this.moveToNextSymbol();
            this.generateCode(Fct.JPF, 0);
            int tmp = this.codeIndex;
            this.statement(inLoop);
            this.modifyCodeOperand(tmp, this.codeIndex + 1);
            if (this.nextSymbol == Symbol.ELSE) {
                this.modifyCodeOperand(tmp, this.codeIndex + 2);
                this.generateCode(Fct.JMP, 0);
                tmp = this.codeIndex;
                this.moveToNextSymbol();
                this.statement(inLoop);
                this.modifyCodeOperand(tmp, this.codeIndex + 1);
            }
        } else if (this.nextSymbol == Symbol.LEFT_BRACE) {
            this.moveToNextSymbol();
            this.statement(inLoop);
            while (this.nextSymbol == Symbol.LEFT_BRACE || LEADING_WORDS.contains((Object)this.nextSymbol) || this.nextSymbol == Symbol.ID) {
                Symbol tmp = this.nextSymbol;
                this.statement(inLoop);
                if (tmp != Symbol.LEFT_BRACE) continue;
                if (this.nextSymbol == Symbol.RIGHT_BRACE) {
                    this.moveToNextSymbol();
                    continue;
                }
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "}");
            }
            if (this.nextSymbol != Symbol.RIGHT_BRACE) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "}");
            }
            this.moveToNextSymbol();
        } else if (this.nextSymbol == Symbol.WHILE) {
            int tmp1 = this.codeIndex + 1;
            this.moveToNextSymbol();
            if (this.nextSymbol != Symbol.LEFT_PARENTHESIS) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "(");
            }
            this.moveToNextSymbol();
            this.disjunctionExpression();
            if (this.nextSymbol != Symbol.RIGHT_PARENTHESIS) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ")");
            }
            this.moveToNextSymbol();
            this.generateCode(Fct.JPF, 0);
            int tmp2 = this.codeIndex;
            this.breakRecorder.createNewLabel();
            this.continueRecorder.createNewLabel();
            this.statement(true);
            this.generateCode(Fct.JMP, tmp1);
            this.modifyCodeOperand(tmp2, this.codeIndex + 1);
            this.breakRecorder.modifyCode(this.codeIndex + 1);
            this.breakRecorder.deleteCurrentLabel();
            this.continueRecorder.modifyCode(tmp1);
            this.continueRecorder.deleteCurrentLabel();
        } else if (this.nextSymbol == Symbol.BREAK) {
            if (!inLoop) {
                throw new CompileException(CompileError.SEMANTIC_ERROR, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "'break' appears outside a loop.");
            }
            this.generateCode(Fct.JMP, 0);
            this.breakRecorder.addCode(this.codeIndex);
            this.moveToNextSymbol();
            if (this.nextSymbol != Symbol.SEMICOLON) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ";");
            }
            this.moveToNextSymbol();
        } else if (this.nextSymbol == Symbol.FOR) {
            this.moveToNextSymbol();
            if (this.nextSymbol != Symbol.ID) {
                throw new CompileException(CompileError.ILLEGAL_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "" + (Object)((Object)this.nextSymbol));
            }
            String id = (String)this.nextObject;
            Integer address = this.symbolTable.get(id);
            if (address == null) {
                address = ++this.offset;
                this.symbolTable.put(id, address);
            }
            this.moveToNextSymbol();
            if (this.nextSymbol != Symbol.ASSIGN) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "=");
            }
            this.moveToNextSymbol();
            this.numericExpression();
            this.generateCode(Fct.STO, address);
            int tmp1 = this.codeIndex + 1;
            if (this.nextSymbol != Symbol.TO) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "to");
            }
            this.moveToNextSymbol();
            this.numericExpression();
            this.generateCode(Fct.LOD, address);
            this.generateCode(Fct.OPR, (Object)Opr.GREATER_EQUAL);
            this.generateCode(Fct.JPF, 0);
            int tmp2 = this.codeIndex;
            this.generateCode(Fct.JMP, 0);
            int tmp3 = this.codeIndex;
            int tmp4 = this.codeIndex + 1;
            if (this.nextSymbol != Symbol.STEP) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "step");
            }
            this.moveToNextSymbol();
            this.numericExpression();
            this.generateCode(Fct.LOD, address);
            this.generateCode(Fct.OPR, (Object)Opr.PLUS);
            this.generateCode(Fct.STO, address);
            this.generateCode(Fct.JMP, tmp1);
            this.modifyCodeOperand(tmp3, this.codeIndex + 1);
            this.breakRecorder.createNewLabel();
            this.continueRecorder.createNewLabel();
            this.statement(true);
            this.generateCode(Fct.JMP, tmp4);
            this.modifyCodeOperand(tmp2, this.codeIndex + 1);
            this.breakRecorder.modifyCode(this.codeIndex + 1);
            this.breakRecorder.deleteCurrentLabel();
            this.continueRecorder.modifyCode(tmp4);
            this.continueRecorder.deleteCurrentLabel();
        } else if (this.nextSymbol == Symbol.CONTINUE) {
            if (!inLoop) {
                throw new CompileException(CompileError.SEMANTIC_ERROR, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "'continue' appears outside a loop.");
            }
            this.generateCode(Fct.JMP, 0);
            this.continueRecorder.addCode(this.codeIndex);
            this.moveToNextSymbol();
            if (this.nextSymbol != Symbol.SEMICOLON) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ";");
            }
            this.moveToNextSymbol();
        } else if (this.nextSymbol == Symbol.RETURN) {
            this.moveToNextSymbol();
            if (this.nextSymbol != Symbol.SEMICOLON) {
                this.disjunctionExpression();
                this.generateCode(Fct.FUN_RETURN, 0);
            } else {
                this.generateCode(Fct.VOID_RETURN, 0);
            }
            if (this.nextSymbol != Symbol.SEMICOLON) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ";");
            }
            this.moveToNextSymbol();
        }
    }

    private void function() {
        this.breakRecorder.init();
        this.continueRecorder.init();
        this.symbolTable.clear();
        this.codes = new ArrayList();
        this.codeIndex = -1;
        if (this.nextSymbol == null) {
            this.moveToNextSymbol();
        }
        if (this.nextSymbol != Symbol.FUNCTION) {
            throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "function");
        }
        this.moveToNextSymbol();
        if (this.nextSymbol != Symbol.ID) {
            throw new CompileException(CompileError.ILLEGAL_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "" + (Object)((Object)this.nextSymbol));
        }
        String functionName = (String)this.nextObject;
        this.moveToNextSymbol();
        int parameterNumber = 0;
        this.offset = -1;
        if (this.nextSymbol == Symbol.LEFT_PARENTHESIS) {
            this.moveToNextSymbol();
        } else {
            throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "(");
        }
        while (this.nextSymbol != Symbol.RIGHT_PARENTHESIS) {
            if (this.nextSymbol != Symbol.ID) {
                throw new CompileException(CompileError.ILLEGAL_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "" + (Object)((Object)this.nextSymbol));
            }
            String id = (String)this.nextObject;
            ++parameterNumber;
            ++this.offset;
            this.symbolTable.put(id, this.offset);
            this.moveToNextSymbol();
            if (this.nextSymbol != Symbol.RIGHT_PARENTHESIS && this.nextSymbol != Symbol.COMMA) {
                throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, ") or ,");
            }
            if (this.nextSymbol != Symbol.COMMA) continue;
            this.moveToNextSymbol();
        }
        this.moveToNextSymbol();
        this.generateCode(Fct.INT, 0);
        int tmp = this.codeIndex;
        this.statement(false);
        this.generateCode(Fct.VOID_RETURN, 0);
        this.modifyCodeOperand(tmp, this.offset + 1);
        this.library.put(functionName, parameterNumber, this.codes);
    }

    void compile() {
        block2: {
            this.program = this.program + "END ";
            do {
                this.function();
                if (this.nextSymbol == Symbol.END) break block2;
            } while (this.nextSymbol == Symbol.FUNCTION);
            throw new CompileException(CompileError.MISSING_SYMBOL, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "function");
        }
        for (FunctionWrapper functionWrapper : this.neededFunctions) {
            if (this.library.containsFunction(functionWrapper.functionName, functionWrapper.parameterNumber)) continue;
            throw new CompileException(CompileError.UNDEFINED_FUNCTION, this.linePos == 0 ? this.lineNumber - 1 : this.lineNumber, this.previousLinePos, "Function name: " + functionWrapper.functionName + " Parameter number: " + functionWrapper.parameterNumber);
        }
    }

    private class LabelRecorder {
        private HashMap<Integer, HashSet<Integer>> labels;
        private int currentLabel;

        private LabelRecorder() {
        }

        void init() {
            this.currentLabel = 0;
            this.labels = new HashMap();
        }

        void addCode(int codeIndex) {
            this.labels.get(this.currentLabel).add(codeIndex);
        }

        void createNewLabel() {
            this.labels.put(++this.currentLabel, new HashSet());
        }

        void modifyCode(int target) {
            HashSet<Integer> previousCodeIndexes = this.labels.get(this.currentLabel);
            for (int index : previousCodeIndexes) {
                ((Code)Compiler.this.codes.get(index)).setOperand(target);
            }
        }

        void deleteCurrentLabel() {
            this.labels.remove(this.currentLabel--);
        }
    }

    private static class FunctionWrapper {
        final String functionName;
        final int parameterNumber;

        FunctionWrapper(String functionName, int parameterNumber) {
            this.functionName = functionName;
            this.parameterNumber = parameterNumber;
        }
    }
}

