/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.zlang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

class Storage {
    private static final ConcurrentHashMap<Class<?>, Class<?>> PRIMITIVE_CLASSES = new ConcurrentHashMap<Class<?>, Class<?>>(){
        {
            this.put(Byte.class, Byte.TYPE);
            this.put(Character.class, Character.TYPE);
            this.put(Short.class, Short.TYPE);
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Double.class, Double.TYPE);
        }
    };
    private static final ConcurrentHashMap<String, Class<?>> PRIMITIVE_CLASS_MAP = new ConcurrentHashMap<String, Class<?>>(){
        {
            this.put("byte", Byte.TYPE);
            this.put("char", Character.TYPE);
            this.put("short", Short.TYPE);
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
        }
    };
    private static volatile Storage instance = null;
    private ConcurrentHashMap<String, Class<?>> classMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CopyOnWriteArrayList<Constructor<?>>> constructorListMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, CopyOnWriteArrayList<Method>>> methodListMapMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, CopyOnWriteArrayList<Method>>> publicMethodListMapMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Field>> fieldMapMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Field>> publicFieldMapMap = new ConcurrentHashMap();

    private Storage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Storage getInstance() {
        if (instance != null) return instance;
        Class<Storage> clazz = Storage.class;
        synchronized (Storage.class) {
            if (instance != null) return instance;
            instance = new Storage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    Class<?> getClass(String className) throws ClassNotFoundException {
        Class<?> result = PRIMITIVE_CLASS_MAP.get(className);
        if (result != null) {
            return result;
        }
        result = this.classMap.get(className);
        if (result != null) {
            return result;
        }
        Class<?> tmp = Class.forName(className);
        result = this.classMap.putIfAbsent(className, tmp);
        if (result == null) {
            return tmp;
        }
        return result;
    }

    private static boolean matchParameter(Object parameter, Class<?> parameterType) {
        if (!parameterType.isPrimitive()) {
            return parameterType.isInstance(parameter);
        }
        return PRIMITIVE_CLASSES.get(parameter.getClass()) == parameterType;
    }

    private static boolean matchParameters(Object[] parameters, Class<?>[] parameterTypes) {
        int length = parameters.length;
        if (length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (parameters[i] == null || Storage.matchParameter(parameters[i], parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    Constructor<?> getConstructor(Class<?> clazz, Object[] parameters) {
        CopyOnWriteArrayList tmp;
        String className = clazz.getName();
        CopyOnWriteArrayList<Constructor<Object>> constructorList = this.constructorListMap.get(className);
        if (constructorList == null && (constructorList = this.constructorListMap.putIfAbsent(className, tmp = new CopyOnWriteArrayList())) == null) {
            constructorList = tmp;
        }
        for (Constructor<?> constructor : constructorList) {
            if (!Storage.matchParameters(parameters, constructor.getParameterTypes())) continue;
            return constructor;
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!Storage.matchParameters(parameters, constructor.getParameterTypes())) continue;
            constructorList.add(constructor);
            return constructor;
        }
        return null;
    }

    Method getMethod(Class<?> clazz, String methodName, Object[] parameters) {
        CopyOnWriteArrayList tmp;
        CopyOnWriteArrayList<Method> methodList;
        ConcurrentHashMap tmp2;
        String className = clazz.getName();
        ConcurrentHashMap<String, CopyOnWriteArrayList<Method>> methodListMap = this.methodListMapMap.get(className);
        if (methodListMap == null && (methodListMap = this.methodListMapMap.putIfAbsent(className, tmp2 = new ConcurrentHashMap())) == null) {
            methodListMap = tmp2;
        }
        if ((methodList = methodListMap.get(methodName)) == null && (methodList = methodListMap.putIfAbsent(className, tmp = new CopyOnWriteArrayList())) == null) {
            methodList = tmp;
        }
        for (Method method : methodList) {
            if (!method.getName().equals(methodName) || !Storage.matchParameters(parameters, method.getParameterTypes())) continue;
            return method;
        }
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !Storage.matchParameters(parameters, method.getParameterTypes())) continue;
                methodList.add(method);
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    Method getPublicMethod(Class<?> clazz, String methodName, Object[] parameters) {
        CopyOnWriteArrayList tmp;
        CopyOnWriteArrayList<Method> methodList;
        ConcurrentHashMap tmp2;
        String className = clazz.getName();
        ConcurrentHashMap<String, CopyOnWriteArrayList<Method>> methodListMap = this.publicMethodListMapMap.get(className);
        if (methodListMap == null && (methodListMap = this.publicMethodListMapMap.putIfAbsent(className, tmp2 = new ConcurrentHashMap())) == null) {
            methodListMap = tmp2;
        }
        if ((methodList = methodListMap.get(methodName)) == null && (methodList = methodListMap.putIfAbsent(className, tmp = new CopyOnWriteArrayList())) == null) {
            methodList = tmp;
        }
        for (Method method : methodList) {
            if (!method.getName().equals(methodName) || !Storage.matchParameters(parameters, method.getParameterTypes())) continue;
            return method;
        }
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !Storage.matchParameters(parameters, method.getParameterTypes())) continue;
            methodList.add(method);
            return method;
        }
        return null;
    }

    Field getField(Class<?> clazz, String fieldName) {
        Field result;
        ConcurrentHashMap tmp;
        String className = clazz.getName();
        ConcurrentHashMap<String, Field> fieldMap = this.fieldMapMap.get(className);
        if (fieldMap == null && (fieldMap = this.fieldMapMap.putIfAbsent(className, tmp = new ConcurrentHashMap())) == null) {
            fieldMap = tmp;
        }
        if ((result = fieldMap.get(fieldName)) != null) {
            return result;
        }
        while (clazz != Object.class) {
            try {
                result = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (result != null) {
                fieldMap.putIfAbsent(fieldName, result);
                return result;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    Field getPublicField(Class<?> clazz, String fieldName) {
        Field result;
        ConcurrentHashMap tmp;
        String className = clazz.getName();
        ConcurrentHashMap<String, Field> fieldMap = this.publicFieldMapMap.get(className);
        if (fieldMap == null && (fieldMap = this.publicFieldMapMap.putIfAbsent(className, tmp = new ConcurrentHashMap())) == null) {
            fieldMap = tmp;
        }
        if ((result = fieldMap.get(fieldName)) != null) {
            return result;
        }
        try {
            result = clazz.getField(fieldName);
            if (result != null) {
                fieldMap.putIfAbsent(fieldName, result);
                return result;
            }
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        return null;
    }
}

