/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.concurrentutils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import xiaofei.library.concurrentutils.util.Action;
import xiaofei.library.concurrentutils.util.Function;

public class ObjectCanary2<T> {
    private volatile T object = null;
    private final AtomicInteger pendingTaskNumber = new AtomicInteger(0);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void action(final Action<? super T> action) {
        if (this.object == null || this.pendingTaskNumber.get() > 0) {
            this.pendingTaskNumber.incrementAndGet();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (ObjectCanary2.this.object == null) {
                        try {
                            ObjectCanary2.this.lock.lock();
                            while (ObjectCanary2.this.object == null) {
                                ObjectCanary2.this.condition.await();
                            }
                            action.call(ObjectCanary2.this.object);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        finally {
                            ObjectCanary2.this.lock.unlock();
                        }
                    } else {
                        action.call(ObjectCanary2.this.object);
                    }
                    ObjectCanary2.this.pendingTaskNumber.decrementAndGet();
                }
            });
        } else {
            action.call(this.object);
        }
    }

    public <R> R calculate(final Function<? super T, ? extends R> function) {
        if (this.object == null || this.pendingTaskNumber.get() > 0) {
            this.pendingTaskNumber.incrementAndGet();
            Future future = this.executor.submit(new Callable<R>(){

                @Override
                public R call() throws Exception {
                    Object result = null;
                    if (ObjectCanary2.this.object == null) {
                        try {
                            ObjectCanary2.this.lock.lock();
                            while (ObjectCanary2.this.object == null) {
                                ObjectCanary2.this.condition.await();
                            }
                            result = function.call(ObjectCanary2.this.object);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        finally {
                            ObjectCanary2.this.lock.unlock();
                        }
                    } else {
                        result = function.call(ObjectCanary2.this.object);
                    }
                    ObjectCanary2.this.pendingTaskNumber.decrementAndGet();
                    return result;
                }
            });
            try {
                return (R)future.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return null;
        }
        return function.call(this.object);
    }

    public void set(T object) {
        if (object == null) {
            throw new IllegalArgumentException("You cannot assign null to this object.");
        }
        this.lock.lock();
        this.object = object;
        this.condition.signalAll();
        this.lock.unlock();
    }
}

