/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.concurrentutils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import xiaofei.library.concurrentutils.util.Action;
import xiaofei.library.concurrentutils.util.Condition;
import xiaofei.library.concurrentutils.util.Function;
import xiaofei.library.concurrentutils.util.IdenticalFunction;
import xiaofei.library.concurrentutils.util.NonNullCondition;

public class ObjectCanary<T> {
    private final Condition<T> nonNullCondition = new NonNullCondition();
    private final Function<T, T> identicalFunction = new IdenticalFunction();
    private volatile T object;
    private final Lock lock;
    private final java.util.concurrent.locks.Condition condition;
    private final ConcurrentHashMap<Condition<? super T>, ConcurrentLinkedQueue<Action<? super T>>> waitingActions;
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();

    public <R extends T> ObjectCanary(R object) {
        this.object = object;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.waitingActions = new ConcurrentHashMap();
    }

    public ObjectCanary() {
        this(null);
    }

    public void actionNonNullNonBlocking(Action<? super T> action) {
        this.actionNonBlocking(action, this.nonNullCondition);
    }

    public void actionNonBlocking(Action<? super T> action, final Condition<? super T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Condition cannot be null.");
        }
        this.lock.lock();
        if (condition.satisfy(this.object)) {
            action.call(this.object);
        } else {
            if (!this.waitingActions.containsKey(condition)) {
                this.waitingActions.put(condition, new ConcurrentLinkedQueue());
                EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        ConcurrentLinkedQueue q = (ConcurrentLinkedQueue)ObjectCanary.this.waitingActions.get(condition);
                        try {
                            Action tmpAction;
                            ObjectCanary.this.lock.lock();
                            while (!condition.satisfy(ObjectCanary.this.object)) {
                                ObjectCanary.this.condition.await();
                            }
                            while ((tmpAction = (Action)q.poll()) != null) {
                                tmpAction.call(ObjectCanary.this.object);
                            }
                            ObjectCanary.this.waitingActions.remove(condition);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        finally {
                            ObjectCanary.this.lock.unlock();
                        }
                    }
                });
            }
            this.waitingActions.get(condition).offer(action);
        }
        this.lock.unlock();
    }

    public void actionNonNull(Action<? super T> action) {
        this.action(action, this.nonNullCondition);
    }

    public void action(Action<? super T> action) {
        this.action(action, null);
    }

    public void action(final Action<? super T> action, Condition<? super T> condition) {
        this.performFunctionUnderCondition(new Function<T, Void>(){

            @Override
            public Void call(T o) {
                action.call(o);
                return null;
            }
        }, condition, true);
    }

    public <R> R calculateNonNull(Function<? super T, ? extends R> function) {
        return this.calculate(function, this.nonNullCondition);
    }

    public <R> R calculate(Function<? super T, ? extends R> function) {
        return this.calculate(function, null);
    }

    public <R> R calculate(Function<? super T, ? extends R> function, Condition<? super T> condition) {
        return this.performFunctionUnderCondition(function, condition, false);
    }

    public void wait(Condition<? super T> condition) {
        this.performFunctionUnderCondition(null, condition, false);
    }

    public void waitUntilNonNull() {
        this.wait(this.nonNullCondition);
    }

    public boolean satisfy(Condition<? super T> condition) {
        this.lock.lock();
        boolean result = condition.satisfy(this.object);
        this.lock.unlock();
        return result;
    }

    public void set(T object) {
        this.lock.lock();
        this.object = object;
        this.condition.signalAll();
        this.lock.unlock();
    }

    public T get() {
        return this.object;
    }

    public T getNonNull() {
        return this.get(this.nonNullCondition);
    }

    public T get(Condition<? super T> condition) {
        return this.performFunctionUnderCondition(this.identicalFunction, condition, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R performFunctionUnderCondition(Function<? super T, ? extends R> function, Condition<? super T> condition, boolean signal) {
        R result = null;
        try {
            this.lock.lock();
            while (condition != null && !condition.satisfy(this.object)) {
                this.condition.await();
            }
            if (function != null) {
                result = function.call(this.object);
            }
            if (signal) {
                this.condition.signalAll();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }
}

