/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.comparatorgenerator.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TypeUtils {
    private TypeUtils() {
    }

    public static Field getFieldIncludingSuperClass(Class<?> clazz, String fieldName) {
        for (Class<?> tmp = clazz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static boolean isNoArgMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes == null || parameterTypes.length == 0;
    }

    public static List<Method> getNoArgMethods(Class<?> clazz) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (method.isSynthetic() || !TypeUtils.isNoArgMethod(method)) continue;
            result.add(method);
        }
        return result;
    }

    public static Method getMethodIncludingSuperClass(Class<?> clazz, String methodName) {
        for (Class<?> tmp = clazz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            try {
                return clazz.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static void checkField(Field field) {
        Class<?> type = field.getType();
        if (!Comparable.class.isAssignableFrom(type) && !type.isPrimitive()) {
            throw new RuntimeException("The field " + field.getName() + " is not a primitive type or does not implement the Comparable interface. " + "It must be a primitive type or implement the Comparable interface.");
        }
    }

    public static void checkMethod(Method method) {
        Class<?> type = method.getReturnType();
        if (!Comparable.class.isAssignableFrom(type) && !type.isPrimitive()) {
            throw new RuntimeException("The return type of the method " + method.getName() + " is not a primitive type or does not implement the Comparable interface. " + "It must be a primitive type or implement the Comparable interface.");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            throw new RuntimeException("The method " + method.getName() + " has parameters. It must have no parameters.");
        }
    }
}

