/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.comparatorgenerator.internal;

import java.util.Comparator;
import java.util.List;
import xiaofei.library.comparatorgenerator.Order;
import xiaofei.library.comparatorgenerator.internal.Member;
import xiaofei.library.comparatorgenerator.internal.SortingCriterion;

public class GeneratedComparator<T>
implements Comparator<T> {
    private List<SortingCriterion> criteria;

    public GeneratedComparator(List<SortingCriterion> criteria) {
        this.criteria = criteria;
    }

    private static <T> int compare(Member member, T o1, T o2) {
        Object v1 = member.getValue(o1);
        Object v2 = member.getValue(o2);
        if (v1 == null) {
            throw new IllegalArgumentException("The value of " + member.getName() + " of " + o1 + " is null.");
        }
        if (v2 == null) {
            throw new IllegalArgumentException("The value of " + member.getName() + " of " + o2 + " is null.");
        }
        if (v1 instanceof Comparable && v2 instanceof Comparable) {
            return ((Comparable)Comparable.class.cast(v1)).compareTo(Comparable.class.cast(v2));
        }
        Class<?> type = member.getType();
        if (type == Boolean.TYPE) {
            return Boolean.valueOf((Boolean)v1).compareTo((boolean)((Boolean)v2));
        }
        if (type == Byte.TYPE) {
            return Byte.valueOf((Byte)v1).compareTo((byte)((Byte)v2));
        }
        if (type == Character.TYPE) {
            return Character.valueOf(((Character)v1).charValue()).compareTo(Character.valueOf(((Character)v2).charValue()));
        }
        if (type == Short.TYPE) {
            return Short.valueOf((Short)v1).compareTo((short)((Short)v2));
        }
        if (type == Integer.TYPE) {
            return Integer.valueOf((Integer)v1).compareTo((int)((Integer)v2));
        }
        if (type == Long.TYPE) {
            return Long.valueOf((Long)v1).compareTo((long)((Long)v2));
        }
        if (type == Float.TYPE) {
            return Float.valueOf(((Float)v1).floatValue()).compareTo(Float.valueOf(((Float)v2).floatValue()));
        }
        if (type == Double.TYPE) {
            return Double.valueOf((Double)v1).compareTo((double)((Double)v2));
        }
        throw new IllegalStateException("Congratulations! You have found a bug which I do not know. Please tell me so that I can add it here.");
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == null || o2 == null) {
            throw new NullPointerException("Parameter is null.");
        }
        for (SortingCriterion criterion : this.criteria) {
            Member member = criterion.getMember();
            Order order = criterion.getOrder();
            int result = GeneratedComparator.compare(member, o1, o2);
            if (result == 0) continue;
            return order == Order.ASCENDING ? result : -result;
        }
        return 0;
    }
}

