/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.comparatorgenerator.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xiaofei.library.comparatorgenerator.Criterion;
import xiaofei.library.comparatorgenerator.Order;
import xiaofei.library.comparatorgenerator.internal.FieldMember;
import xiaofei.library.comparatorgenerator.internal.MethodMember;
import xiaofei.library.comparatorgenerator.internal.SortingCriterion;
import xiaofei.library.comparatorgenerator.internal.TypeUtils;

public class AnnotationUtils {
    private static final String TAG = "ComparatorGenerator: ";
    private static final boolean DEBUG = false;
    private static Method method = null;

    private AnnotationUtils() {
    }

    public static Map<Integer, SortingCriterion> getCriteria(Class<?> clazz) {
        ConcurrentHashMap<Integer, SortingCriterion> result = new ConcurrentHashMap<Integer, SortingCriterion>();
        for (Class<?> tmp = clazz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            Map map = null;
            try {
                if (method != null) {
                    map = (Map)method.invoke(null, tmp);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (map == null) {
                Field[] fields;
                for (Field field : fields = tmp.getDeclaredFields()) {
                    Criterion criterion = field.getAnnotation(Criterion.class);
                    if (criterion == null) continue;
                    int priority = criterion.priority();
                    Order order = criterion.order();
                    SortingCriterion prev = result.put(priority, new SortingCriterion(new FieldMember(field), order));
                    if (prev == null) continue;
                    throw new RuntimeException("The priority value " + priority + " has already been set to the member " + prev.getMember().getName() + ". Please specify another priority value.");
                }
                List<Method> methods = TypeUtils.getNoArgMethods(tmp);
                for (Method method : methods) {
                    Criterion criterion = method.getAnnotation(Criterion.class);
                    if (criterion == null) continue;
                    int priority = criterion.priority();
                    Order order = criterion.order();
                    SortingCriterion prev = result.put(priority, new SortingCriterion(new MethodMember(method), order));
                    if (prev == null) continue;
                    throw new RuntimeException("The priority value " + priority + " has already been set to the member " + prev.getMember().getName() + ". Please specify another priority value.");
                }
                continue;
            }
            for (Map.Entry entry : map.entrySet()) {
                SortingCriterion prev = (SortingCriterion)result.put((Integer)entry.getKey(), (SortingCriterion)entry.getValue());
                if (prev == null) continue;
                throw new RuntimeException("The priority value " + entry.getKey() + " has already been set to the member " + prev.getMember().getName() + ". Please specify another priority value.");
            }
        }
        return result;
    }

    static {
        try {
            Class<?> clazz = Class.forName("xiaofei.library.comparatorgenerator.CriterionManager");
            method = clazz.getDeclaredMethod("getCriteria", Class.class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

