/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.comparatorgenerator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import xiaofei.library.comparatorgenerator.Order;
import xiaofei.library.comparatorgenerator.internal.AnnotationUtils;
import xiaofei.library.comparatorgenerator.internal.FieldMember;
import xiaofei.library.comparatorgenerator.internal.GeneratedComparator;
import xiaofei.library.comparatorgenerator.internal.Member;
import xiaofei.library.comparatorgenerator.internal.MethodMember;
import xiaofei.library.comparatorgenerator.internal.SortingCriterion;
import xiaofei.library.comparatorgenerator.internal.TypeUtils;

public class ComparatorGenerator<T> {
    private Class<T> clazz;
    private TreeMap<Integer, SortingCriterion> criteria;

    public ComparatorGenerator(Class<T> clazz) {
        this.clazz = clazz;
        this.criteria = new TreeMap(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        Map<Integer, SortingCriterion> map = AnnotationUtils.getCriteria(clazz);
        for (Map.Entry<Integer, SortingCriterion> entry : map.entrySet()) {
            SortingCriterion prev = this.criteria.put(entry.getKey(), entry.getValue());
            if (prev == null) continue;
            throw new RuntimeException("The priority value " + entry.getKey() + " has already been set to the member " + prev.getMember().getName() + ". Please specify another priority value.");
        }
    }

    public ComparatorGenerator<T> addCriterion(int priority, String memberName) {
        return this.addCriterion(priority, memberName, Order.ASCENDING);
    }

    public ComparatorGenerator<T> addCriterion(int priority, String memberName, Order order) {
        Field field = TypeUtils.getFieldIncludingSuperClass(this.clazz, memberName);
        Method method = TypeUtils.getMethodIncludingSuperClass(this.clazz, memberName);
        if (field == null && method == null) {
            throw new IllegalArgumentException("Member " + memberName + " does not exist.");
        }
        if (field != null && method != null) {
            throw new IllegalArgumentException("A field and a method have the same name: " + memberName + ". Which one do you want?");
        }
        Member member = field != null ? new FieldMember(field) : new MethodMember(method);
        SortingCriterion prev = this.criteria.put(priority, new SortingCriterion(member, order));
        if (prev != null) {
            throw new IllegalArgumentException("The priority value " + priority + " has already been set to the member " + prev.getMember().getName() + ". Please specify another priority value.");
        }
        return this;
    }

    public Comparator<T> generate() {
        ArrayList<SortingCriterion> criteria = new ArrayList<SortingCriterion>();
        criteria.addAll(this.criteria.values());
        if (criteria.isEmpty()) {
            throw new RuntimeException("There is no sorting criterion specified for Class " + this.clazz.getName() + ". " + "Please specify at least one criterion " + "by adding @Criterion on the corresponding field or method or using " + "ComparatorGenerator.addCriterion(int, String, Order).");
        }
        this.clazz = null;
        this.criteria = null;
        return new GeneratedComparator(criteria);
    }
}

