/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.comparatorgenerator.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TypeUtils {
    private TypeUtils() {
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> tmp = clazz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = tmp.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                result.add(field);
            }
        }
        return result;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            for (Class<?> tmp = clazz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
                Field field = clazz.getDeclaredField(fieldName);
                if (field == null) continue;
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isNoArgMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes == null || parameterTypes.length == 0;
    }

    public static List<Method> getNoArgMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> tmp = clazz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = tmp.getDeclaredMethods()) {
                if (method.isSynthetic() || !TypeUtils.isNoArgMethod(method)) continue;
                result.add(method);
            }
        }
        return result;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        try {
            for (Class<?> tmp = clazz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
                Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                if (method == null) continue;
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static void checkField(Field field) {
        Class<?> type = field.getType();
        if (!Comparable.class.isAssignableFrom(type) && !type.isPrimitive()) {
            throw new RuntimeException("The field " + field.getName() + " is not a primitive type or does not implement the Comparable interface. " + "It must be a primitive type or implement the Comparable interface.");
        }
    }

    public static void checkMethod(Method method) {
        Class<?> type = method.getReturnType();
        if (!Comparable.class.isAssignableFrom(type) && !type.isPrimitive()) {
            throw new RuntimeException("The return type of the method " + method.getName() + " is not a primitive type or does not implement the Comparable interface. " + "It must be a primitive type or implement the Comparable interface.");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            throw new RuntimeException("The method " + method.getName() + " has parameters. It must have no parameters.");
        }
    }
}

